/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui;

import java.util.Set;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetInspector;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;

public abstract class AbstractProjectCommand
extends AbstractUICommand {
    public boolean isEnabled(UIContext context) {
        return this.isProjectRequired() && this.containsProject(context) && this.constraintsSatisfied(context) && super.isEnabled(context) || !this.isProjectRequired() && super.isEnabled(context);
    }

    private boolean constraintsSatisfied(UIContext context) {
        Set facets = FacetInspector.getRequiredFacets((Class)this.getMetadata(context).getType());
        return FacetInspector.isConstraintSatisfied((Faceted)this.getSelectedProject(context), (Set)facets);
    }

    protected abstract boolean isProjectRequired();

    protected boolean containsProject(UIContext context) {
        return Projects.containsProject(this.getProjectFactory(), context);
    }

    protected Project getSelectedProject(UIContextProvider contextProvider) {
        return this.getSelectedProject(contextProvider.getUIContext());
    }

    protected Project getSelectedProject(UIContext context) {
        Project selectedProject = Projects.getSelectedProject(this.getProjectFactory(), context);
        if (this.isProjectRequired() && selectedProject == null) {
            throw new IllegalStateException("A project is required in the current context");
        }
        return selectedProject;
    }

    protected abstract ProjectFactory getProjectFactory();
}

