/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.building;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.forge.addon.projects.building.BuildMessage;
import org.jboss.forge.addon.projects.building.BuildMessageImpl;
import org.jboss.forge.addon.projects.building.BuildResult;

public class BuildResultBuilder
implements BuildResult {
    private boolean success = true;
    private Set<BuildMessage> messages = new LinkedHashSet<BuildMessage>();

    private BuildResultBuilder() {
    }

    public static BuildResultBuilder create() {
        return new BuildResultBuilder();
    }

    public BuildResultBuilder succeeded() {
        this.success = true;
        return this;
    }

    public BuildResultBuilder failed() {
        this.success = false;
        return this;
    }

    public BuildResultBuilder status(boolean status) {
        this.success = status;
        return this;
    }

    public BuildResultBuilder addMessage(BuildMessage.Severity severity, String message) {
        this.messages.add(new BuildMessageImpl(severity, message));
        return this;
    }

    public BuildResultBuilder addMessage(BuildMessage message) {
        this.messages.add(message);
        return this;
    }

    public BuildResult build() {
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public Iterable<BuildMessage> getMessages() {
        return this.messages;
    }
}

