/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.explicit;

import java.io.IOException;
import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.plugins.structure.explicit.StructureMetaDataObjectFactory;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class DeclaredStructure
extends AbstractStructureDeployer {
    public DeclaredStructure() {
        this.setRelativeOrder(0);
    }

    public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException {
        block7: {
            try {
                boolean trace = this.log.isTraceEnabled();
                if (this.isLeaf(file)) break block7;
                boolean isJBossStructure = false;
                if (trace) {
                    this.log.trace((Object)(file + " is not a leaf"));
                }
                try {
                    VirtualFile jbossStructure = file.getChild("META-INF/jboss-structure.xml");
                    if (jbossStructure != null) {
                        this.log.trace((Object)"... context has a META-INF/jboss-structure.xml");
                        URL url = jbossStructure.toURL();
                        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
                        Unmarshaller unmarshaller = factory.newUnmarshaller();
                        StructureMetaDataObjectFactory ofactory = new StructureMetaDataObjectFactory();
                        unmarshaller.unmarshal(url.toString(), (ObjectModelFactory)ofactory, (Object)metaData);
                        isJBossStructure = true;
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Exception while looking for META-INF/jboss-structure.xml: " + e));
                }
                if (trace) {
                    this.log.trace((Object)(file + " isJBossStructure: " + isJBossStructure));
                }
                return isJBossStructure;
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
            }
        }
        return false;
    }
}

