/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class AbstractVFSDeployment
extends AbstractDeployment
implements VFSDeployment {
    private static final long serialVersionUID = 3992263833911364088L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rootUrl", URL.class), new ObjectStreamField("path", String.class)};
    private URL rootUrl;
    private String path;
    private transient VirtualFile root;

    static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractVFSDeployment() {
    }

    public AbstractVFSDeployment(VirtualFile root) {
        super(AbstractVFSDeployment.safeVirtualFileName(root));
        this.root = root;
    }

    public VirtualFile getRoot() {
        if (this.root == null) {
            try {
                VirtualFile top = VFS.getRoot((URL)this.rootUrl);
                this.root = top.findChild(this.path);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot find root: " + e);
            }
        }
        return this.root;
    }

    public String getSimpleName() {
        return this.getRoot().getName();
    }

    public String toString() {
        return "AbstractVFSDeployment(" + this.getSimpleName() + ")";
    }

    private void writeObject(ObjectOutputStream out) throws IOException, URISyntaxException {
        String pathName;
        URL url = this.rootUrl;
        if (url == null) {
            VFS vfs = this.getRoot().getVFS();
            url = vfs.getRoot().toURL();
        }
        if ((pathName = this.path) == null) {
            pathName = this.getRoot().getPathName();
        }
        out.defaultWriteObject();
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("rootUrl", url);
        fields.put("path", pathName);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ObjectInputStream.GetField fields = in.readFields();
        this.rootUrl = (URL)fields.get("rootUrl", null);
        this.path = (String)fields.get("path", null);
    }
}

