/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import javassist.ClassPool;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.annotations.GenericAnnotationResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAnnotationDeployer
extends AbstractSimpleRealDeployer<Module> {
    private boolean forceAnnotations;

    public GenericAnnotationDeployer() {
        super(Module.class);
        this.setStage(DeploymentStages.PRE_REAL);
        this.setOutput(AnnotationEnvironment.class);
    }

    public void setForceAnnotations(boolean forceAnnotations) {
        this.forceAnnotations = forceAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentUnit unit, Module module) throws DeploymentException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating AnnotationEnvironment for " + unit + ", module: " + module + ", force annotations: " + this.forceAnnotations));
        }
        ClassPool pool = ClassPool.getDefault();
        ClassLoader classLoader = unit.getClassLoader();
        GenericAnnotationResourceVisitor visitor = new GenericAnnotationResourceVisitor(pool, classLoader);
        visitor.setForceAnnotations(this.forceAnnotations);
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            module.visit((ResourceVisitor)visitor);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        unit.addAttachment(AnnotationEnvironment.class, (Object)visitor.getEnv());
    }
}

