/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.plugins.annotations.ClassSignaturePair;
import org.jboss.deployers.plugins.annotations.DefaultElement;
import org.jboss.deployers.plugins.annotations.ParametersElement;
import org.jboss.deployers.plugins.annotations.WeakClassLoaderHolder;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.annotations.Element;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationEnvironment
extends WeakClassLoaderHolder
implements AnnotationEnvironment,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(DefaultAnnotationEnvironment.class);
    private transient Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> env = new HashMap<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>();

    public DefaultAnnotationEnvironment(ClassLoader classLoader) {
        super(classLoader);
    }

    protected Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> getEnv() {
        if (this.env == null) {
            throw new IllegalArgumentException("Null env, previously serialized?");
        }
        return this.env;
    }

    void putAnnotation(Class<? extends Annotation> annClass, ElementType type, String className, Signature signature) {
        Set classes;
        Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> env;
        Map<ElementType, Set<ClassSignaturePair>> elements;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding annotation @" + annClass.getSimpleName() + " for " + className + " at type " + (Object)((Object)type) + ", signature: " + signature));
        }
        if ((elements = (env = this.getEnv()).get(annClass)) == null) {
            elements = new HashMap<ElementType, Set<ClassSignaturePair>>();
            env.put(annClass, elements);
        }
        if ((classes = elements.get((Object)type)) == null) {
            classes = CollectionsFactory.createLazySet();
            elements.put(type, classes);
        }
        classes.add(new ClassSignaturePair(className, signature));
    }

    protected Set<ClassSignaturePair> getCSPairs(Class<? extends Annotation> annClass, ElementType type) {
        Set<ClassSignaturePair> pairs = null;
        Map<ElementType, Set<ClassSignaturePair>> elements = this.getEnv().get(annClass);
        if (elements != null) {
            pairs = elements.get((Object)type);
        }
        return pairs != null ? pairs : Collections.emptySet();
    }

    protected Set<Class<?>> transformToClasses(Set<ClassSignaturePair> pairs) {
        if (pairs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet classes = new HashSet(pairs.size());
        for (ClassSignaturePair pair : pairs) {
            classes.add(this.loadClass(pair.getClassName()));
        }
        return classes;
    }

    protected <A extends Annotation, M extends AccessibleObject> Set<Element<A, M>> transformToElements(ElementType type, Class<A> annClass, Class<M> aoClass) {
        Set<ClassSignaturePair> pairs = this.getCSPairs(annClass, type);
        if (pairs.isEmpty()) {
            return Collections.emptySet();
        }
        ClassLoader classLoader = this.getClassLoader();
        HashSet<Element<A, M>> elements = new HashSet<Element<A, M>>();
        for (ClassSignaturePair pair : pairs) {
            DefaultElement element = type == ElementType.PARAMETER ? new ParametersElement<A, M>(classLoader, pair.getClassName(), pair.getSignature(), annClass, aoClass) : new DefaultElement<A, M>(classLoader, pair.getClassName(), pair.getSignature(), annClass, aoClass);
            elements.add(element);
        }
        return elements;
    }

    public boolean hasClassAnnotatedWith(Class<? extends Annotation> annotation) {
        return !this.getCSPairs(annotation, ElementType.TYPE).isEmpty();
    }

    public Set<Class<?>> classIsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.transformToClasses(this.getCSPairs(annotation, ElementType.TYPE));
    }

    public <A extends Annotation> Set<Element<A, Constructor>> classHasConstructorAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.CONSTRUCTOR, annotation, Constructor.class);
    }

    public <A extends Annotation> Set<Element<A, Field>> classHasFieldAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.FIELD, annotation, Field.class);
    }

    public <A extends Annotation> Set<Element<A, Method>> classHasMethodAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.METHOD, annotation, Method.class);
    }

    public <A extends Annotation> Set<Element<A, AccessibleObject>> classHasParameterAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(ElementType.PARAMETER, annotation, AccessibleObject.class);
    }

    protected Class<Annotation> getAnnotationClass(String annotationName) {
        Class<Annotation> clazz = this.loadClass(annotationName);
        if (!Annotation.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Annotation name " + annotationName + " doesn't extend Annotation class.");
        }
        return clazz;
    }

    public boolean hasClassAnnotatedWith(String annotationName) {
        return this.hasClassAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    public Set<Class<?>> classIsAnnotatedWith(String annotationName) {
        return this.classIsAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    public Set<Element<Annotation, Constructor>> classHasConstructorAnnotatedWith(String annotationName) {
        return this.classHasConstructorAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    public Set<Element<Annotation, Field>> classHasFieldAnnotatedWith(String annotationName) {
        return this.classHasFieldAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    public Set<Element<Annotation, Method>> classHasMethodAnnotatedWith(String annotationName) {
        return this.classHasMethodAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    public Set<Element<Annotation, AccessibleObject>> classHasParameterAnnotatedWith(String annotationName) {
        return this.classHasParameterAnnotatedWith(this.getAnnotationClass(annotationName));
    }
}

