/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.MissingPolicyException;
import org.jboss.cache.config.parsing.ParsedAttributes;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.ModernizablePolicy;
import org.jboss.cache.util.FileLookup;
import org.jboss.cache.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationParser2x {
    private static final Log log = LogFactory.getLog(XmlConfigurationParser2x.class);
    public static final String ATTR = "attribute";
    public static final String NAME = "name";

    public Configuration parseFile(String filename) {
        InputStream is = new FileLookup().lookupFile(filename);
        if (is == null) {
            throw new ConfigurationException("Unable to find config file " + filename + " either in classpath or on the filesystem!");
        }
        return this.parseStream(is);
    }

    public Configuration parseStream(InputStream stream) {
        Element root = XmlConfigHelper.getDocumentRoot(stream);
        Element mbeanElement = this.getMBeanElement(root);
        return this.parseConfiguration(mbeanElement);
    }

    public Configuration parseConfiguration(Element configurationRoot) {
        ParsedAttributes attributes = XmlConfigHelper.extractAttributes(configurationRoot);
        this.handleRemovedAttributes(attributes);
        this.handleRenamedAttributes(attributes);
        Configuration c = new Configuration();
        XmlConfigHelper.setValues(c, attributes.stringAttribs, false, false);
        this.setXmlValues(c, attributes.xmlAttribs);
        if (c.getEvictionConfig() != null) {
            this.correctEvictionUnlimitedValues(c.getEvictionConfig());
        }
        return c;
    }

    private void correctEvictionUnlimitedValues(EvictionConfig ec) {
        EvictionRegionConfig def = ec.getDefaultEvictionRegionConfig();
        def.getEvictionAlgorithmConfig();
    }

    protected void handleRemovedAttributes(ParsedAttributes attributes) {
        String evictionPolicy = attributes.stringAttribs.remove("EvictionPolicyClass");
        if (evictionPolicy != null) {
            throw new ConfigurationException("XmlConfigurationParser does not support the JBC 1.x attribute EvictionPolicyClass. Set the default eviction policy via the policyClass element in the EvictionConfig section");
        }
        String multiplexerService = attributes.stringAttribs.remove("MultiplexerService");
        if (multiplexerService != null) {
            throw new ConfigurationException("XmlConfigurationParser does not support the JBC 1.x attribute MultiplexerService. Inject the multiplexer directly using Configuration.getRuntimeConfig().setMuxChannelFactory()");
        }
        String serviceName = attributes.stringAttribs.remove("ServiceName");
        if (serviceName != null) {
            log.warn((Object)"XmlConfigurationParser does not support the deprecated attribute ServiceName. If JMX registration is needed, register a CacheJmxWrapper or PojoCacheJmxWrapper in JMX with the desired name");
        }
    }

    private void handleRenamedAttributes(ParsedAttributes attributes) {
        Element clc;
        String keepStats = attributes.stringAttribs.remove("UseInterceptorMbeans");
        if (keepStats != null && attributes.stringAttribs.get("ExposeManagementStatistics") == null) {
            log.warn((Object)"Found non-existent JBC 1.x attribute 'UseInterceptorMbeans' and replaced with 'ExposeManagementStatistics'. Please update your config to use the new attribute name");
            attributes.stringAttribs.put("ExposeManagementStatistics", keepStats);
        }
        if ((clc = attributes.xmlAttribs.remove("CacheLoaderConfiguration")) != null && attributes.xmlAttribs.get("CacheLoaderConfig") == null) {
            log.warn((Object)"Found non-existent JBC 1.x attribute 'CacheLoaderConfiguration' and replaced with 'CacheLoaderConfig'. Please update your config to use the new attribute name");
            attributes.xmlAttribs.put("CacheLoaderConfig", clc);
        }
    }

    protected Element getMBeanElement(Element root) {
        NodeList list = root.getElementsByTagName("mbean");
        if (list == null) {
            throw new ConfigurationException("Can't find mbean tag");
        }
        if (list.getLength() > 1) {
            throw new ConfigurationException("Has multiple mbean tag");
        }
        Node node = list.item(0);
        if (node.getNodeType() != 1) {
            throw new ConfigurationException("Can't find mbean element");
        }
        Element element = (Element)node;
        return element;
    }

    protected void setXmlValues(Configuration conf, Map<String, Element> attribs) {
        for (Map.Entry<String, Element> entry : attribs.entrySet()) {
            String propname = entry.getKey();
            if ("BuddyReplicationConfiguration".equals(propname) || "BuddyReplicationConfig".equals(propname)) {
                BuddyReplicationConfig brc = XmlConfigurationParser2x.parseBuddyReplicationConfig(entry.getValue());
                conf.setBuddyReplicationConfig(brc);
                continue;
            }
            if ("CacheLoaderConfiguration".equals(propname) || "CacheLoaderConfig".equals(propname)) {
                CacheLoaderConfig clc = XmlConfigurationParser2x.parseCacheLoaderConfig(entry.getValue());
                conf.setCacheLoaderConfig(clc);
                continue;
            }
            if ("EvictionPolicyConfiguration".equals(propname) || "EvictionPolicyConfig".equals(propname)) {
                EvictionConfig ec = XmlConfigurationParser2x.parseEvictionConfig(entry.getValue());
                conf.setEvictionConfig(ec);
                continue;
            }
            if ("ClusterConfig".equals(propname)) {
                String jgc = XmlConfigurationParser2x.parseClusterConfigXml(entry.getValue());
                conf.setClusterConfig(jgc);
                continue;
            }
            throw new ConfigurationException("Unknown configuration element " + propname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BuddyReplicationConfig parseBuddyReplicationConfig(Element element) {
        BuddyReplicationConfig brc;
        block10: {
            brc = new BuddyReplicationConfig();
            brc.setEnabled(XmlConfigHelper.readBooleanContents(element, "buddyReplicationEnabled"));
            brc.setDataGravitationRemoveOnFind(XmlConfigHelper.readBooleanContents(element, "dataGravitationRemoveOnFind", true));
            brc.setDataGravitationSearchBackupTrees(XmlConfigHelper.readBooleanContents(element, "dataGravitationSearchBackupTrees", true));
            brc.setAutoDataGravitation(brc.isEnabled() && XmlConfigHelper.readBooleanContents(element, "autoDataGravitation", false));
            String strBuddyCommunicationTimeout = XmlConfigHelper.readStringContents(element, "buddyCommunicationTimeout");
            try {
                Object var5_3;
                try {
                    brc.setBuddyCommunicationTimeout(Integer.parseInt(strBuddyCommunicationTimeout));
                }
                catch (Exception e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)e.getMessage());
                    }
                    var5_3 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using buddy communication timeout of " + brc.getBuddyCommunicationTimeout() + " millis"));
                    }
                    break block10;
                }
                var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using buddy communication timeout of " + brc.getBuddyCommunicationTimeout() + " millis"));
                }
                throw throwable;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using buddy communication timeout of " + brc.getBuddyCommunicationTimeout() + " millis"));
            }
        }
        String buddyPoolName = XmlConfigHelper.readStringContents(element, "buddyPoolName");
        if ("".equals(buddyPoolName)) {
            buddyPoolName = null;
        }
        brc.setBuddyPoolName(buddyPoolName);
        String buddyLocatorClass = XmlConfigHelper.readStringContents(element, "buddyLocatorClass");
        if (buddyLocatorClass == null || buddyLocatorClass.length() == 0) {
            buddyLocatorClass = NextMemberBuddyLocator.class.getName();
        }
        Properties props = null;
        props = XmlConfigHelper.readPropertiesContents(element, "buddyLocatorProperties");
        BuddyReplicationConfig.BuddyLocatorConfig blc = new BuddyReplicationConfig.BuddyLocatorConfig();
        blc.setBuddyLocatorClass(buddyLocatorClass);
        blc.setBuddyLocatorProperties(props);
        brc.setBuddyLocatorConfig(blc);
        return brc;
    }

    public static CacheLoaderConfig parseCacheLoaderConfig(Element element) {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.setPassivation(XmlConfigHelper.readBooleanContents(element, "passivation"));
        String s = XmlConfigHelper.readStringContents(element, "preload");
        if (s != null && s.length() > 0) {
            clc.setPreload(s);
        }
        clc.setShared(XmlConfigHelper.readBooleanContents(element, "shared"));
        NodeList cacheLoaderNodes = element.getElementsByTagName("cacheloader");
        for (int i = 0; i < cacheLoaderNodes.getLength(); ++i) {
            Node node = cacheLoaderNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element indivElement = (Element)node;
            CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
            iclc.setAsync(XmlConfigHelper.readBooleanContents(indivElement, "async", false));
            iclc.setIgnoreModifications(XmlConfigHelper.readBooleanContents(indivElement, "ignoreModifications", false));
            iclc.setFetchPersistentState(XmlConfigHelper.readBooleanContents(indivElement, "fetchPersistentState", false));
            iclc.setPurgeOnStartup(XmlConfigHelper.readBooleanContents(indivElement, "purgeOnStartup", false));
            iclc.setClassName(XmlConfigHelper.readStringContents(indivElement, "class"));
            iclc.setProperties(XmlConfigHelper.readPropertiesContents(indivElement, "properties"));
            CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = XmlConfigurationParser2x.parseSingletonStoreConfig(indivElement);
            if (ssc != null) {
                iclc.setSingletonStoreConfig(ssc);
            }
            clc.addIndividualCacheLoaderConfig(iclc);
        }
        return clc;
    }

    private static CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig parseSingletonStoreConfig(Element cacheLoaderelement) {
        Node singletonStoreNode = cacheLoaderelement.getElementsByTagName("singletonStore").item(0);
        if (singletonStoreNode != null && singletonStoreNode.getNodeType() == 1) {
            Element singletonStoreElement = (Element)singletonStoreNode;
            boolean singletonStoreEnabled = XmlConfigHelper.readBooleanContents(singletonStoreElement, "enabled");
            String singletonStoreClass = XmlConfigHelper.readStringContents(singletonStoreElement, "class");
            Properties singletonStoreproperties = XmlConfigHelper.readPropertiesContents(singletonStoreElement, "properties");
            CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = new CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig();
            ssc.setSingletonStoreEnabled(singletonStoreEnabled);
            ssc.setSingletonStoreClass(singletonStoreClass);
            ssc.setSingletonStoreproperties(singletonStoreproperties);
            return ssc;
        }
        return null;
    }

    public static EvictionConfig parseEvictionConfig(Element element) {
        EvictionConfig evictionConfig = new EvictionConfig();
        if (element != null) {
            String temp = XmlConfigHelper.getTagContents(element, "policyClass", ATTR, NAME);
            String defaultEvPolicyClassName = null;
            if (temp != null && temp.length() > 0) {
                defaultEvPolicyClassName = temp;
                EvictionAlgorithmConfig eac = XmlConfigurationParser2x.getEvictionAlgorithmConfig(temp);
                evictionConfig.getDefaultEvictionRegionConfig().setEvictionAlgorithmConfig(eac);
            }
            temp = XmlConfigHelper.getTagContents(element, "wakeUpIntervalSeconds", ATTR, NAME);
            int wakeupIntervalSeconds = 0;
            if (temp != null) {
                wakeupIntervalSeconds = Integer.parseInt(temp);
            }
            if (wakeupIntervalSeconds <= 0) {
                wakeupIntervalSeconds = 5000;
            }
            evictionConfig.setWakeupInterval(wakeupIntervalSeconds * 1000);
            int eventQueueSize = 0;
            temp = XmlConfigHelper.getTagContents(element, "eventQueueSize", ATTR, NAME);
            if (temp != null) {
                eventQueueSize = Integer.parseInt(temp);
            }
            if (eventQueueSize <= 0) {
                eventQueueSize = 200000;
            }
            evictionConfig.getDefaultEvictionRegionConfig().setEventQueueSize(eventQueueSize);
            NodeList list = element.getElementsByTagName("region");
            if (list != null && list.getLength() > 0) {
                ArrayList<EvictionRegionConfig> regionConfigs = new ArrayList<EvictionRegionConfig>(list.getLength());
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    try {
                        EvictionRegionConfig evictionRegionConfig = XmlConfigurationParser2x.parseEvictionRegionConfig((Element)node, defaultEvPolicyClassName, eventQueueSize);
                        if (!evictionRegionConfig.getRegionFqn().equals(RegionManagerImpl.DEFAULT_REGION)) {
                            regionConfigs.add(evictionRegionConfig);
                            continue;
                        }
                        evictionConfig.getDefaultEvictionRegionConfig().setEventQueueSize(evictionRegionConfig.getEventQueueSize());
                        evictionConfig.getDefaultEvictionRegionConfig().setEvictionAlgorithmConfig(evictionRegionConfig.getEvictionAlgorithmConfig());
                        continue;
                    }
                    catch (MissingPolicyException missingPolicy) {
                        LogFactory.getLog(EvictionConfig.class).warn((Object)missingPolicy.getLocalizedMessage());
                        throw missingPolicy;
                    }
                }
                evictionConfig.setEvictionRegionConfigs(regionConfigs);
            }
        }
        return evictionConfig;
    }

    private static EvictionRegionConfig parseEvictionRegionConfig(Element element, String defaultEvPolicyClassName, int defaultQueueCapacity) {
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionName(element.getAttribute(NAME));
        String temp = element.getAttribute("eventQueueSize");
        if (temp != null && temp.length() > 0) {
            erc.setEventQueueSize(Integer.parseInt(temp));
        } else {
            erc.setEventQueueSize(defaultQueueCapacity);
        }
        String evictionClass = element.getAttribute("policyClass");
        if (!(evictionClass != null && evictionClass.length() != 0 || (evictionClass = defaultEvPolicyClassName) != null && evictionClass.length() != 0)) {
            throw new MissingPolicyException("There is no Eviction Policy Class specified on the region or for the entire cache!");
        }
        EvictionAlgorithmConfig algorithmConfig = XmlConfigurationParser2x.getEvictionAlgorithmConfig(evictionClass);
        XmlConfigurationParser2x.parseEvictionPolicyConfig(element, algorithmConfig);
        erc.setEvictionAlgorithmConfig(algorithmConfig);
        return erc;
    }

    private static EvictionAlgorithmConfig getEvictionAlgorithmConfig(String evictionClass) {
        EvictionAlgorithmConfig algorithmConfig;
        EvictionAlgorithm algorithm;
        EvictionConfig.assertIsTransformable(evictionClass);
        try {
            EvictionPolicy ep = (EvictionPolicy)Util.getInstance(evictionClass);
            Class<? extends EvictionAlgorithm> algoClass = ((ModernizablePolicy)((Object)ep)).modernizePolicy();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Using algo class " + algoClass));
            }
            algorithm = Util.getInstance(algoClass);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Eviction class is not properly loaded in classloader", e);
        }
        try {
            algorithmConfig = algorithm.getConfigurationClass().newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate eviction configuration of class " + algorithm.getConfigurationClass(), e);
        }
        return algorithmConfig;
    }

    private static void parseEvictionPolicyConfig(Element element, EvictionAlgorithmConfig target) {
        target.reset();
        ParsedAttributes attributes = XmlConfigHelper.extractAttributes(element);
        HashMap<String, String> updatedElements = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.stringAttribs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.indexOf("Seconds") > 0) {
                key = key.substring(0, key.length() - "Seconds".length());
                value = value.trim() + "000";
            }
            int intval = 1;
            try {
                intval = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.debug((Object)"Unable to parse number", (Throwable)e);
            }
            value = intval < 1 ? "-1" : value;
            updatedElements.put(key, value);
        }
        attributes.stringAttribs.clear();
        attributes.stringAttribs.putAll(updatedElements);
        XmlConfigHelper.setValues(target, attributes.stringAttribs, false, true);
        XmlConfigHelper.setValues(target, attributes.xmlAttribs, true, true);
    }

    public static String parseClusterConfigXml(Element config) {
        StringBuilder buffer = new StringBuilder();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            buffer.append(protocol);
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            if (attrLength > 0) {
                buffer.append('(');
            }
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                buffer.append(name);
                buffer.append('=');
                buffer.append(value);
                if (a >= attrLength - 1) continue;
                buffer.append(';');
            }
            if (attrLength > 0) {
                buffer.append(')');
            }
            buffer.append(':');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }
}

