/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.Region;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTimerTask;
import org.jboss.cache.factories.annotations.Destroy;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.jmx.annotations.MBean;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.util.concurrent.locks.LockContainer;
import org.jboss.cache.util.concurrent.locks.ReentrantSharedLockContainer;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
@MBean(objectName="RegionManager", description="Manages eviction and marshalling regions")
public class RegionManagerImpl
implements RegionManager {
    public static final Fqn DEFAULT_REGION = Fqn.fromString("/_default_");
    private RegionRegistry regionsRegistry;
    private boolean defaultInactive;
    protected static final Log log = LogFactory.getLog(RegionManagerImpl.class);
    protected static final boolean trace = log.isTraceEnabled();
    CacheSPI<?, ?> cache;
    private boolean usingEvictions;
    private EvictionConfig evictionConfig;
    private final EvictionTimerTask evictionTimerTask = new EvictionTimerTask();
    private final LockContainer<Fqn> regionLocks = new ReentrantSharedLockContainer<Fqn>(4);
    protected Configuration configuration;
    protected RPCManager rpcManager;
    protected LockManager lockManager;
    protected BuddyFqnTransformer buddyFqnTransformer;
    private boolean isUsingBR;

    protected final boolean isRegionLocked(Fqn fqn) {
        return this.regionLocks.isLocked(fqn);
    }

    protected final void lock(Fqn fqn) {
        this.regionLocks.acquireLock(fqn);
    }

    protected final void unlock(Fqn fqn) {
        this.regionLocks.releaseLock(fqn);
    }

    @Inject
    public void injectDependencies(CacheSPI cache, Configuration configuration, RPCManager rpcManager, LockManager lockManager, BuddyFqnTransformer transformer, RegionRegistry regionsRegistry) {
        this.cache = cache;
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.lockManager = lockManager;
        this.buddyFqnTransformer = transformer;
        this.regionsRegistry = regionsRegistry;
    }

    @Start
    public void start() {
        if (trace) {
            log.trace((Object)"Starting region manager");
        }
        this.isUsingBR = this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled();
        this.evictionConfig = this.configuration.getEvictionConfig();
        if (this.evictionConfig != null && this.evictionConfig.isValidConfig()) {
            this.evictionConfig = this.configuration.getEvictionConfig();
            EvictionRegionConfig defaultRegion = this.configuration.getEvictionConfig().getDefaultEvictionRegionConfig();
            if (defaultRegion.getEvictionAlgorithmConfig() != null) {
                defaultRegion.getEvictionAlgorithmConfig().validate();
            }
            for (EvictionRegionConfig erc : this.configuration.getEvictionConfig().getEvictionRegionConfigs()) {
                this.evictionConfig.applyDefaults(erc);
                erc.validate();
            }
            this.setEvictionConfig(this.configuration.getEvictionConfig());
            this.setUsingEvictions(true);
        } else {
            this.setUsingEvictions(false);
            log.debug((Object)"Not using an EvictionPolicy");
        }
        this.setDefaultInactive(this.configuration.isInactiveOnStartup());
        if (this.isUsingEvictions()) {
            this.evictionTimerTask.init(this.evictionConfig.getWakeupInterval(), (ThreadFactory)this.configuration.getRuntimeConfig().getEvictionTimerThreadFactory(), this.regionsRegistry);
        }
    }

    @Stop
    protected void stop() {
        if (this.isUsingEvictions()) {
            this.evictionTimerTask.stop();
        }
    }

    @Destroy
    protected void destroy() {
        this.regionsRegistry.clear();
        this.regionLocks.reset();
    }

    @Override
    public boolean isUsingEvictions() {
        return this.usingEvictions;
    }

    @Override
    public boolean isDefaultInactive() {
        return this.defaultInactive;
    }

    @Override
    public void setDefaultInactive(boolean defaultInactive) {
        this.defaultInactive = defaultInactive;
        Region defaultRegion = (Region)this.regionsRegistry.get(Fqn.ROOT);
        if (defaultRegion != null) {
            defaultRegion.setActive(!defaultInactive);
        }
    }

    @Override
    public void setContextClassLoaderAsCurrent(Fqn fqn) {
        Region region;
        ClassLoader regionCL;
        if (fqn.isChildOf(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)) {
            fqn = fqn.size() <= 2 ? Fqn.ROOT : fqn.getSubFqn(2, fqn.size());
        }
        ClassLoader classLoader = regionCL = (region = this.getRegion(fqn, false)) == null ? null : region.getClassLoader();
        if (regionCL != null) {
            Thread.currentThread().setContextClassLoader(regionCL);
        }
    }

    @Override
    public Region getRegion(Fqn fqn, boolean createIfAbsent) {
        return this.getRegion(fqn, Region.Type.ANY, createIfAbsent);
    }

    @Override
    public Region getValidMarshallingRegion(Fqn fqn) {
        if (fqn == null) {
            return null;
        }
        return this.getRegion(fqn, Region.Type.MARSHALLING, false);
    }

    @Override
    public Region getRegion(Fqn fqn, Region.Type type, boolean createIfAbsent) {
        Region r;
        Fqn fqnToUse;
        if (this.isUsingBR && fqn != null) {
            if (BuddyFqnTransformer.isBackupFqn(fqn)) {
                fqn = this.buddyFqnTransformer.getActualFqn(fqn);
            }
        }
        if (trace) {
            log.trace((Object)("Contents of RegionsRegistry: " + this.regionsRegistry));
        }
        if (DEFAULT_REGION.equals(fqnToUse = fqn)) {
            fqnToUse = Fqn.ROOT;
        }
        if (this.regionsRegistry.containsKey(fqnToUse)) {
            r = (Region)this.regionsRegistry.get(fqnToUse);
            if (type == Region.Type.ANY || type == Region.Type.MARSHALLING && r.getClassLoader() != null || type == Region.Type.EVICTION && r.getEvictionRegionConfig() != null) {
                return r;
            }
        }
        if (createIfAbsent) {
            r = new RegionImpl(fqnToUse, this);
            Region previous = this.regionsRegistry.putIfAbsent(fqnToUse, r);
            if (previous != null) {
                r = previous;
            }
            if (type == Region.Type.MARSHALLING) {
                r.registerContextClassLoader(this.getClass().getClassLoader());
            }
            return r;
        }
        Region nextBestThing = null;
        Fqn nextFqn = fqnToUse;
        while (nextBestThing == null) {
            if (this.regionsRegistry.containsKey(nextFqn = nextFqn.getParent())) {
                Region r2 = (Region)this.regionsRegistry.get(nextFqn);
                if (trace) {
                    log.trace((Object)("Trying next region " + nextFqn + " and got " + r2));
                }
                if (type == Region.Type.ANY || type == Region.Type.MARSHALLING && r2.getClassLoader() != null || type == Region.Type.EVICTION && r2.getEvictionRegionConfig() != null) {
                    nextBestThing = r2;
                }
            }
            if (!nextFqn.isRoot()) continue;
        }
        if (type == Region.Type.EVICTION && nextBestThing != null && nextBestThing.getFqn().isRoot() && !this.regionsRegistry.containsKey(Fqn.ROOT)) {
            log.trace((Object)"No default eviction region; returning null");
            nextBestThing = null;
        }
        return nextBestThing;
    }

    @Override
    public Region getRegion(String fqn, boolean createIfAbsent) {
        return this.getRegion(Fqn.fromString(fqn), createIfAbsent);
    }

    @Override
    public boolean removeRegion(Fqn fqn) {
        Region r = (Region)this.regionsRegistry.remove(fqn);
        return r != null;
    }

    @Override
    public EvictionTimerTask getEvictionTimerTask() {
        return this.evictionTimerTask;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void activate(Fqn fqn) throws RegionNotEmptyException {
        this.activate(fqn, false);
    }

    @Override
    public void activateIfEmpty(Fqn fqn) {
        this.activate(fqn, true);
    }

    private void activate(Fqn fqn, boolean suppressRegionNotEmptyException) {
        try {
            Region r;
            if (trace) {
                log.trace((Object)("Activating region " + fqn));
            }
            if ((r = this.getRegion(fqn, false)) != null) {
                if (!this.defaultInactive && r.getClassLoader() == null) {
                    this.removeRegion(fqn);
                } else {
                    r.setStatus(Region.Status.ACTIVATING);
                    if (this.configuration.isFetchInMemoryState()) {
                        this.activateRegion(r.getFqn(), suppressRegionNotEmptyException);
                    }
                    r.setActive(true);
                }
            } else if (this.defaultInactive) {
                r = this.getRegion(fqn, true);
                r.setStatus(Region.Status.ACTIVATING);
                if (this.configuration.isFetchInMemoryState()) {
                    this.activateRegion(r.getFqn(), suppressRegionNotEmptyException);
                }
                r.setActive(true);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateRegion(Fqn fqn, boolean suppressRegionNotEmptyException) {
        block19: {
            Node<Object, Object> subtreeRoot = this.cache.getNode(fqn);
            if (log.isDebugEnabled()) {
                log.debug((Object)("activating " + fqn));
            }
            try {
                this.lock(fqn);
                BuddyManager buddyManager = this.cache.getBuddyManager();
                if (buddyManager == null) {
                    List<Address> members;
                    if (subtreeRoot == null) {
                        NodeSPI<?, ?> root = this.cache.getRoot();
                        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                        subtreeRoot = root.addChild(fqn);
                        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
                    }
                    if ((members = this.cache.getMembers()) != null && !members.isEmpty()) {
                        this.rpcManager.fetchPartialState(members, subtreeRoot.getFqn());
                    }
                } else if (!BuddyFqnTransformer.isBackupFqn(fqn)) {
                    List<Address> buddies = buddyManager.getBackupDataOwners();
                    for (Address buddy : buddies) {
                        ArrayList<Address> sources = new ArrayList<Address>(1);
                        if (!this.cache.getMembers().contains(buddy)) continue;
                        sources.add(buddy);
                        Fqn buddyRoot = this.buddyFqnTransformer.getBackupFqn(buddy, fqn);
                        subtreeRoot = this.cache.peek(buddyRoot, false, false);
                        if (subtreeRoot == null) {
                            NodeSPI<?, ?> root = this.cache.getRoot();
                            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                            subtreeRoot = root.addChild(buddyRoot);
                            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
                        }
                        this.rpcManager.fetchPartialState(sources, fqn, subtreeRoot.getFqn());
                    }
                } else {
                    log.info((Object)"Attempting to activate a backup region.  Not attempting to retrieve any state as this will be pushed.");
                }
            }
            catch (Throwable t) {
                log.error((Object)("failed to activate " + fqn), t);
                try {
                    this.inactivateRegion(fqn);
                }
                catch (Exception e) {
                    log.error((Object)("failed inactivating " + fqn), (Throwable)e);
                }
                if (t instanceof RegionNotEmptyException) {
                    if (!suppressRegionNotEmptyException) {
                        throw (RegionNotEmptyException)t;
                    }
                    break block19;
                }
                if (t instanceof CacheException) {
                    throw (CacheException)t;
                }
                throw new CacheException(t.getClass().getName() + " " + t.getLocalizedMessage(), t);
            }
            finally {
                this.unlock(fqn);
            }
        }
    }

    @Override
    public boolean isInactive(Fqn fqn) {
        Region region = this.getRegion(fqn, false);
        return region == null ? this.defaultInactive : !region.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inactivateRegion(Fqn fqn) throws CacheException {
        NodeSPI<?, ?> subtreeRoot = null;
        InvocationContext ctx = this.cache.getInvocationContext();
        ctx.getOptionOverrides().setLockAcquisitionTimeout((int)(this.cache.getConfiguration().getLockAcquisitionTimeout() + 5000L));
        try {
            Set<Object> buddies;
            this.lock(fqn);
            if (!this.isInactive(fqn)) {
                this.deactivate(fqn);
            }
            BuddyManager buddyManager = this.cache.getBuddyManager();
            ArrayList<Fqn> list = new ArrayList<Fqn>();
            list.add(fqn);
            if (buddyManager != null && (buddies = this.cache.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, false, false).getChildrenNames()) != null) {
                for (Object buddy : buddies) {
                    list.add(this.buddyFqnTransformer.getBackupFqn((String)buddy, fqn));
                }
            }
            for (Fqn subtree : list) {
                subtreeRoot = this.cache.peek(subtree, false);
                if (subtreeRoot == null) continue;
                this.cache.evict(subtree, true);
            }
        }
        finally {
            this.unlock(fqn);
        }
    }

    @Override
    public boolean hasRegion(Fqn fqn, Region.Type type) {
        Region r = (Region)this.regionsRegistry.get(fqn);
        if (r == null) {
            return false;
        }
        switch (type) {
            case ANY: {
                return true;
            }
            case EVICTION: {
                return r.getEvictionRegionConfig() != null;
            }
            case MARSHALLING: {
                return r.isActive() && r.getClassLoader() != null;
            }
        }
        return false;
    }

    @Override
    public void deactivate(Fqn fqn) {
        try {
            Region region = this.getRegion(fqn, false);
            if (region != null) {
                if (this.defaultInactive && region.getClassLoader() == null) {
                    this.removeRegion(fqn);
                } else {
                    region.setActive(false);
                    if (this.cache.getConfiguration().isFetchInMemoryState()) {
                        this.inactivateRegion(fqn);
                    }
                }
            } else if (!this.defaultInactive) {
                region = this.getRegion(fqn, true);
                region.setActive(false);
                if (this.cache.getConfiguration().isFetchInMemoryState()) {
                    this.inactivateRegion(fqn);
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
        this.regionsRegistry.clear();
    }

    @Override
    public List<Region> getAllRegions(Region.Type type) {
        ArrayList<Region> regions;
        if (type != Region.Type.ANY) {
            regions = new ArrayList();
            for (Region r : this.regionsRegistry.values()) {
                if ((type != Region.Type.EVICTION || r.getEvictionRegionConfig() == null) && (type != Region.Type.MARSHALLING || !r.isActive() || r.getClassLoader() == null)) continue;
                regions.add(r);
            }
        } else {
            regions = new ArrayList(this.regionsRegistry.values());
        }
        Collections.sort(regions);
        return regions;
    }

    @Override
    public void setUsingEvictions(boolean usingEvictions) {
        this.usingEvictions = usingEvictions;
    }

    @Override
    public void setEvictionConfig(EvictionConfig evictionConfig) {
        List<EvictionRegionConfig> ercs = evictionConfig.getEvictionRegionConfigs();
        if (evictionConfig.getDefaultEvictionRegionConfig().getEvictionAlgorithmConfig() != null && !ercs.contains(evictionConfig.getDefaultEvictionRegionConfig())) {
            ercs.add(0, evictionConfig.getDefaultEvictionRegionConfig());
        }
        boolean setDefault = false;
        for (EvictionRegionConfig erc : ercs) {
            Fqn fqn = erc.getRegionFqn();
            if (fqn == null) {
                throw new ConfigurationException("Regions cannot be configured with a null region fqn.  If you configured this region programmatically, ensure that you set the region fqn in EvictionRegionConfig");
            }
            if (trace) {
                log.trace((Object)("Creating eviction region " + fqn));
            }
            if (fqn.equals(DEFAULT_REGION) || fqn.isRoot()) {
                if (setDefault) {
                    throw new ConfigurationException("A default region for evictions has already been set for this cache");
                }
                if (trace) {
                    log.trace((Object)"Applying settings for default region to Fqn.ROOT");
                }
                fqn = Fqn.ROOT;
                setDefault = true;
            }
            Region r = this.getRegion(fqn, true);
            evictionConfig.applyDefaults(erc);
            r.setEvictionRegionConfig(erc);
        }
    }

    @Override
    @ManagedOperation(description="A String representation of all registered regions")
    public String dumpRegions() {
        StringBuilder sb = new StringBuilder();
        if (this.regionsRegistry != null) {
            for (Region r : this.regionsRegistry.values()) {
                sb.append("\tRegion ").append(r);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "RegionManager " + this.dumpRegions();
    }

    @Override
    public CacheSPI getCache() {
        return this.cache;
    }

    @Override
    public void startEvictionThread() {
        this.evictionTimerTask.init(this.evictionConfig.getWakeupInterval(), (ThreadFactory)this.configuration.getRuntimeConfig().getEvictionTimerThreadFactory(), this.regionsRegistry);
    }

    @Override
    public void stopEvictionThread() {
        this.evictionTimerTask.stop();
    }

    @ManagedAttribute(name="numRegions", description="A count of all regions")
    public int getNumRegions() {
        return this.regionsRegistry.size();
    }
}

