/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.server;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.api.config.ServerConfig;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.api.server.Server;
import org.jboss.bootstrap.impl.base.server.SecurityActions;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.bootstrap.spi.server.ServerInitializer;
import org.jboss.bootstrap.spi.server.ServerProvider;
import org.jboss.logging.Logger;
import org.jboss.util.StopWatch;

public abstract class AbstractServer<K extends Server<K, T>, T extends ServerConfig<T>>
extends NotificationBroadcasterSupport
implements ServerProvider<K, T>,
NotificationBroadcaster {
    private static final Logger log = Logger.getLogger(AbstractServer.class);
    private Class<K> actualClass;
    private volatile LifecycleState state;
    private volatile T configuration;
    private ConfigurationValidator<T> validator;
    private volatile ConfigurationInitializer<T> configInitializer;
    private volatile ServerInitializer<K, T> serverInitializer;
    private final List<Bootstrap<K, T>> bootstraps = new CopyOnWriteArrayList<Bootstrap<K, T>>();
    private final List<Bootstrap<K, T>> startedBootstraps = new CopyOnWriteArrayList<Bootstrap<K, T>>();
    private final Map<LifecycleState, Set<LifecycleEventHandler>> eventHandlers = new ConcurrentHashMap<LifecycleState, Set<LifecycleEventHandler>>();
    private volatile Thread startupThread = null;

    protected AbstractServer(Class<K> actualClass) throws IllegalArgumentException {
        this(actualClass, null);
    }

    protected AbstractServer(Class<K> actualClass, T configuration) throws IllegalArgumentException {
        if (actualClass == null) {
            throw new IllegalArgumentException("Actual class must be specified");
        }
        Object configToSet = configuration;
        if (configToSet == null) {
            log.debug((Object)"No configuration has been supplied, so making a default one");
            ServerConfig newConfiguration = null;
            Class<T> configClass = this.getDefaultServerConfigClass();
            try {
                newConfiguration = (ServerConfig)SecurityActions.newInstance(configClass);
                log.debug((Object)("Created new default configuration: " + newConfiguration));
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not create default configuration of type " + configClass, t);
            }
            configToSet = newConfiguration;
        }
        this.setActualClass(actualClass);
        this.setConfiguration(configToSet);
        this.state = LifecycleState.INSTANCIATED;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public synchronized void setConfiguration(T configuration) {
        log.tracef("Set configuration: %s", new Object[]{configuration});
        this.configuration = configuration;
    }

    public final LifecycleState getState() {
        LifecycleState state = this.state;
        if (state == null) {
            throw new IllegalStateException("null state");
        }
        return state;
    }

    public void stop() throws IllegalStateException, Exception {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IllegalStateException, Exception {
        log.trace((Object)"Received request to shutdown");
        Thread startupThread = this.startupThread;
        if (startupThread != null) {
            startupThread.interrupt();
            try {
                startupThread.join();
            }
            catch (InterruptedException ie) {
                log.warn((Object)"Interrupted while shutdown is waiting for server startup to complete");
                Thread.interrupted();
            }
        }
        AbstractServer abstractServer = this;
        synchronized (abstractServer) {
            LifecycleState required = LifecycleState.STARTED;
            LifecycleState actual = this.getState();
            this.checkState(required, actual);
            log.info((Object)("Stopping: " + this));
            StopWatch watch = new StopWatch(true);
            this.setState(LifecycleState.STOPPING);
            this.sendStopJmxNotification();
            log.trace((Object)"Shutting down bootstraps");
            this.shutdownBootstraps();
            log.trace((Object)"Calling implementation class shutdown...");
            this.doShutdown();
            ServerInitializer<K, T> serverInitializer = this.getServerInitializer();
            if (serverInitializer != null) {
                log.tracef("Calling to clean up for shutdown: %s", new Object[]{serverInitializer});
                serverInitializer.cleanup(this.covarientReturn());
            }
            log.infof("Stopped: %s in %s", new Object[]{this, watch});
            this.setState(LifecycleState.STOPPED);
            this.setState(LifecycleState.IDLE);
        }
    }

    public void start() throws IllegalStateException, Exception {
        Thread thread;
        log.trace((Object)"Received request to start");
        if (this.getState().equals((Object)LifecycleState.INSTANCIATED)) {
            log.debug((Object)"Invoking implicit initialization from start()");
            this.initialize();
        }
        StartServerTask task = new StartServerTask();
        this.startupThread = thread = new Thread(task);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        Exception exceptionOnStart = task.getException();
        if (exceptionOnStart != null) {
            throw exceptionOnStart;
        }
    }

    public void addBootstrap(Bootstrap<K, T> bootstrap) throws IllegalStateException, IllegalArgumentException {
        if (bootstrap == null) {
            throw new IllegalArgumentException("Supplied bootstrap was null");
        }
        this.getBootstraps().add(bootstrap);
    }

    public void removeBootstrap(Bootstrap<K, T> bootstrap) throws IllegalStateException, IllegalArgumentException {
        boolean removed = this.bootstraps.remove(bootstrap);
        if (!removed) {
            throw new IllegalArgumentException("Specified bootstrap could not be removed because it is not present in the list");
        }
    }

    public ConfigurationValidator<T> getValidator() {
        return this.validator;
    }

    public final synchronized void initialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        T config = this.getConfiguration();
        if (config == null) {
            throw new IllegalStateException("Configuration must be supplied before server is initialized");
        }
        LifecycleState state = this.getState();
        if (!state.equals((Object)LifecycleState.INSTANCIATED)) {
            throw new IllegalStateException("Cannot initialize an already initialized server, state is: " + state);
        }
        this.setState(LifecycleState.PRE_INIT);
        log.debugf("Initializing server: %s", new Object[]{this});
        this.doInitialize();
        config.freeze();
        this.setState(LifecycleState.INITIALIZED);
        this.setState(LifecycleState.IDLE);
    }

    protected void doInitialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        T config = this.getConfiguration();
        if (config == null) {
            throw new IllegalStateException("Configuration must be supplied before server is initialized");
        }
        ConfigurationInitializer<T> configInitializer = this.getConfigInitializer();
        if (configInitializer != null) {
            log.trace((Object)"Performing configuration initialization...");
            configInitializer.initialize(config);
        } else {
            log.trace((Object)"No configuration initializer supplied, skipping");
        }
        log.trace((Object)"Validating config...");
        this.validate(config);
        ServerInitializer<K, T> serverInitializer = this.getServerInitializer();
        if (serverInitializer != null) {
            serverInitializer.initialize(this.covarientReturn());
        } else {
            log.debugf("No initializer defined, skipping initialization of %s", new Object[]{this});
        }
    }

    public final ServerInitializer<K, T> getServerInitializer() {
        return this.serverInitializer;
    }

    public final synchronized void setServerInitializer(ServerInitializer<K, T> serverInitializer) throws IllegalStateException {
        this.checkMutable(this.getState());
        this.serverInitializer = serverInitializer;
        log.debugf("Set server initializer to %s", new Object[]{serverInitializer});
    }

    public final ConfigurationInitializer<T> getConfigInitializer() {
        return this.configInitializer;
    }

    public final synchronized void setConfigInitializer(ConfigurationInitializer<T> configInitializer) {
        this.checkMutable(this.getState());
        this.configInitializer = configInitializer;
        log.debugf("Set config initializer to %s", new Object[]{configInitializer});
    }

    public final synchronized void setValidator(ConfigurationValidator<T> validator) {
        this.checkMutable(this.getState());
        log.debugf("Setting validator to: %s", new Object[]{validator});
        this.validator = validator;
    }

    public void registerEventHandler(LifecycleState state, LifecycleEventHandler handler) throws IllegalArgumentException {
        this.registerEventHandlers(state, handler);
    }

    public void registerEventHandler(LifecycleEventHandler handler, EnumSet<LifecycleState> states) throws IllegalArgumentException {
        if (handler == null) {
            throw new IllegalArgumentException("handler is required");
        }
        if (states == null) {
            throw new IllegalArgumentException("states is required");
        }
        for (LifecycleState state : states) {
            this.registerEventHandler(state, handler);
        }
    }

    public void registerEventHandler(LifecycleEventHandler handler, LifecycleState ... states) throws IllegalArgumentException {
        if (handler == null) {
            throw new IllegalArgumentException("handler is required");
        }
        if (states == null) {
            throw new IllegalArgumentException("states is required");
        }
        for (LifecycleState state : states) {
            this.registerEventHandler(state, handler);
        }
    }

    public void registerEventHandlers(LifecycleState state, LifecycleEventHandler ... handlers) throws IllegalArgumentException {
        if (handlers == null) {
            throw new IllegalArgumentException("At least one handler is required");
        }
        if (state == null) {
            throw new IllegalArgumentException("state is required");
        }
        Set<LifecycleEventHandler> handlersForEvent = this.getHandlersForEvent(state);
        for (LifecycleEventHandler handler : handlers) {
            handlersForEvent.add(handler);
            log.debugf("Added lifecycle handler %s to fire upon state change to %s for %s", new Object[]{handler, state, this});
        }
    }

    public boolean unregisterEventHandler(LifecycleEventHandler handler, LifecycleState state) throws IllegalArgumentException {
        Set<LifecycleEventHandler> handlers = this.getHandlersForEvent(state);
        boolean removed = handlers.remove(handler);
        log.debugf("Removed lifecycle handler %s from firing upon state change to %s for %s", new Object[]{handler, state, this});
        return removed;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doShutdown() throws Exception;

    protected abstract Class<? extends T> getDefaultServerConfigClass();

    protected void sendStartJmxNotification() {
        this.sendNotificationWithCurrentTimeUserData("org.jboss.system.server.started", 1);
    }

    protected void sendStopJmxNotification() {
        this.sendNotificationWithCurrentTimeUserData("org.jboss.system.server.stopped", 2);
    }

    protected final void sendNotificationWithCurrentTimeUserData(String type, int sequenceNumber) {
        Notification startNotification = new Notification(type, this, sequenceNumber);
        startNotification.setUserData(System.currentTimeMillis());
        this.sendNotification(startNotification);
        log.debugf("Sent JMX Notification: %s", new Object[]{type});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startBootstraps() throws Exception {
        K typedServer = this.covarientReturn();
        for (Bootstrap<K, T> bootstrap : this.getBootstraps()) {
            this.getStartedBootstraps().add(0, bootstrap);
            ClassLoader oldCl = SecurityActions.getThreadContextClassLoader();
            ClassLoader bootstrapCl = bootstrap.getClass().getClassLoader();
            try {
                SecurityActions.setThreadContextClassLoader(bootstrapCl);
                bootstrap.start(typedServer);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(oldCl);
            }
        }
    }

    protected void shutdownBootstraps() {
        List<Bootstrap<K, T>> startedBootstraps = this.getStartedBootstraps();
        K typedServer = this.covarientReturn();
        for (Bootstrap<K, T> bootstrap : startedBootstraps) {
            bootstrap.prepareShutdown(typedServer);
        }
        for (Bootstrap<K, T> bootstrap : startedBootstraps) {
            try {
                bootstrap.shutdown(typedServer);
                if (startedBootstraps.remove(bootstrap)) continue;
                log.warnf("Failed to remove bootstrap after shutdown: %s", new Object[]{bootstrap});
            }
            catch (Throwable t) {
                log.warn((Object)("Error shutting down bootstrap: " + bootstrap), t);
            }
        }
    }

    protected final K covarientReturn() {
        Class<K> actualClass = this.getActualClass();
        try {
            return (K)((Server)actualClass.cast(this));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Actual class is incorrect and " + actualClass + " was not assignable to this instance: " + this, cce);
        }
    }

    private Set<LifecycleEventHandler> getHandlersForEvent(LifecycleState state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("state is required");
        }
        Set<LifecycleEventHandler> handlers = this.eventHandlers.get(state);
        if (handlers == null) {
            handlers = new CopyOnWriteArraySet<LifecycleEventHandler>();
            this.eventHandlers.put(state, handlers);
            log.tracef("Placed empty backing map for lifecycle event handers upon state change into %s for: %s", new Object[]{state, this});
        }
        return handlers;
    }

    private void checkState(LifecycleState required, LifecycleState actual) throws IllegalStateException {
        if (required != actual) {
            throw new IllegalStateException("Server must be in " + LifecycleState.class.getSimpleName() + " " + required + "; is instead: " + actual);
        }
    }

    private void checkState(LifecycleState[] required, LifecycleState actual) throws IllegalStateException {
        for (LifecycleState current : required) {
            if (!current.equals((Object)actual)) continue;
            return;
        }
        throw new IllegalStateException("Server state must be in one of " + Arrays.asList(required) + "; is instead: " + actual);
    }

    private void checkMutable(LifecycleState state) {
        this.checkState(new LifecycleState[]{LifecycleState.INSTANCIATED, LifecycleState.PRE_INIT}, state);
    }

    private void validate(T configuration) throws InvalidConfigurationException, IllegalArgumentException {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration was not specified");
        }
        ConfigurationValidator<T> validator = this.getValidator();
        if (validator != null) {
            log.debugf("Validating configuration using: %s", new Object[]{validator});
            validator.validate(this.getConfiguration());
        } else {
            log.trace((Object)"No validator defined, skipping validation upon configuration");
        }
    }

    private List<Bootstrap<K, T>> getBootstraps() {
        return this.bootstraps;
    }

    List<Bootstrap<K, T>> getStartedBootstraps() {
        return this.startedBootstraps;
    }

    protected final Class<K> getActualClass() {
        return this.actualClass;
    }

    private void setActualClass(Class<K> actualClass) {
        this.actualClass = actualClass;
    }

    private final synchronized void setState(LifecycleState state) throws LifecycleEventException, IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("State was not specified");
        }
        log.tracef("Setting %s to: %s", new Object[]{LifecycleState.class.getSimpleName(), state});
        this.state = state;
        Set<LifecycleEventHandler> handlers = this.getHandlersForEvent(state);
        for (LifecycleEventHandler handler : handlers) {
            try {
                log.tracef("Firing event handler for state change to %s: %s", new Object[]{state, handler});
                handler.handleEvent(state);
            }
            catch (LifecycleEventException t) {
                log.error((Object)("Encountered problem in firing event handler " + handler + " for state change to " + state + " in " + this), (Throwable)t);
                throw t;
            }
        }
    }

    class StartServerTask
    implements Runnable {
        private Exception exception;

        StartServerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractServer thisRef;
            AbstractServer abstractServer = thisRef = AbstractServer.this;
            synchronized (abstractServer) {
                try {
                    LifecycleState required = LifecycleState.IDLE;
                    LifecycleState actual = AbstractServer.this.getState();
                    AbstractServer.this.checkState(required, actual);
                    log.infof("Starting: %s", new Object[]{thisRef});
                    StopWatch watch = new StopWatch(true);
                    AbstractServer.this.setState(LifecycleState.STARTING);
                    log.trace((Object)"Entering implementation class start...");
                    AbstractServer.this.doStart();
                    log.trace((Object)"Starting bootstraps...");
                    AbstractServer.this.startBootstraps();
                    AbstractServer.this.sendStartJmxNotification();
                    log.infof("%s Started in %s", new Object[]{thisRef, watch});
                    AbstractServer.this.setState(LifecycleState.STARTED);
                }
                catch (Exception e) {
                    log.debugf("Encountered exception while starting, caching it to be thrown later: %s", new Object[]{e});
                    this.exception = e;
                    return;
                }
                finally {
                    AbstractServer.this.startupThread = null;
                }
            }
        }

        Exception getException() {
            return this.exception;
        }
    }
}

