/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.ProcessEnvironmentSystemPropertyUpdater;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.operations.SecurityActions;
import org.jboss.dmr.ModelNode;

public class SystemPropertyRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    public static final SystemPropertyRemoveHandler INSTANCE = new SystemPropertyRemoveHandler(null);
    private final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;

    public static ModelNode getOperation(ModelNode address, String name) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("name").set(name);
        return op;
    }

    public SystemPropertyRemoveHandler(ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater) {
        this.systemPropertyUpdater = systemPropertyUpdater;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean reload;
        ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        final String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        final String oldValue = model.hasDefined("value") ? model.get("value").asString() : null;
        boolean applyToRuntime = this.systemPropertyUpdater != null && this.systemPropertyUpdater.isRuntimeSystemPropertyUpdateAllowed(name, oldValue, context.isBooting());
        boolean bl = reload = !applyToRuntime && context.getProcessType().isServer();
        if (applyToRuntime) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    SecurityActions.clearSystemProperty(name);
                    if (SystemPropertyRemoveHandler.this.systemPropertyUpdater != null) {
                        SystemPropertyRemoveHandler.this.systemPropertyUpdater.systemPropertyUpdated(name, null);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            SecurityActions.setSystemProperty(name, oldValue);
                            if (SystemPropertyRemoveHandler.this.systemPropertyUpdater != null) {
                                SystemPropertyRemoveHandler.this.systemPropertyUpdater.systemPropertyUpdated(name, oldValue);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
            }
        });
    }
}

