/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionAddHandler;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class LdapConnectionRemoveHandler
extends AbstractRemoveStepHandler {
    public static final LdapConnectionRemoveHandler INSTANCE = new LdapConnectionRemoveHandler();

    private LdapConnectionRemoveHandler() {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceController.Substate substate;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceName svcName = LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{name});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        ServiceController.Substate substate2 = substate = controller == null ? null : controller.getSubstate();
        boolean removeIt = substate != null && substate.getState() == ServiceController.State.UP && substate.isRestState() ? operation.hasDefined("operation-headers") && operation.get("operation-headers").hasDefined("allow-resource-service-restart") && operation.get(new String[]{"operation-headers", "allow-resource-service-restart"}).asBoolean() : true;
        if (removeIt) {
            context.removeService(svcName);
        } else {
            context.reloadRequired();
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceName svcName = LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{name});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        if (controller != null) {
            context.revertReloadRequired();
        } else {
            LdapConnectionAddHandler.INSTANCE.performRuntime(context, operation, model, null, null);
        }
    }
}

