/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.embedded;

import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;

public class EmbeddedContainerConfiguration
extends CommonContainerConfiguration {
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String modulePath = System.getProperty("module.path");
    private String bundlePath = System.getProperty("bundle.path");

    public EmbeddedContainerConfiguration() {
        if (this.jbossHome == null || this.jbossHome.isEmpty()) {
            this.jbossHome = System.getProperty("jboss.home");
        }
        if (this.modulePath == null || this.modulePath.isEmpty()) {
            this.modulePath = this.jbossHome + "/modules";
        }
        if (this.bundlePath == null || this.bundlePath.isEmpty()) {
            this.bundlePath = this.jbossHome + "/bundles";
        }
    }

    public String getJbossHome() {
        return this.jbossHome;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getBundlePath() {
        return this.bundlePath;
    }

    public void setBundlePath(String bundlePath) {
        this.bundlePath = bundlePath;
    }

    public void validate() throws ConfigurationException {
        super.validate();
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("jbossHome '" + this.jbossHome + "' must exist"));
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("modulePath '" + this.modulePath + "' must exist"));
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("bundlePath '" + this.bundlePath + "' must exist"));
    }
}

