/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.notifications;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.windows.mpns.DeliveryClass;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.internal.Utilities;
import org.jboss.aerogear.windows.mpns.notifications.AbstractNotificationBuilder;

public class CycleTileNotification
implements MpnsNotification {
    private final Builder builder;
    private final List<? extends Map.Entry<String, String>> headers;

    protected CycleTileNotification(Builder builder, List<? extends Map.Entry<String, String>> headers) {
        this.builder = builder;
        this.headers = headers;
    }

    @Override
    public byte[] getRequestBody() {
        return this.builder.toByteArray();
    }

    @Override
    public List<? extends Map.Entry<String, String>> getHttpHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public static class Builder
    extends AbstractNotificationBuilder<Builder, CycleTileNotification> {
        private String tileId;
        private boolean isClear;
        private String smallBackgroundImage;
        private final String[] cycleImages;
        private int count;
        private String title;
        public static final int MAX_IMAGES = 9;

        public Builder() {
            super("token");
            this.contentType("text/xml");
            this.cycleImages = new String[9];
        }

        public Builder tileId(String tileId) {
            this.tileId = tileId;
            return this;
        }

        public Builder isClear(boolean clear) {
            this.isClear = clear;
            return this;
        }

        public Builder smallBackgroundImage(String smallBackgroundImage) {
            this.smallBackgroundImage = smallBackgroundImage;
            return this;
        }

        public Builder cycleImage(int index, String imageName) {
            if (index >= 9) {
                throw new IllegalArgumentException("index " + index + " is greater than maximum allowed cycle images of " + 9);
            }
            this.cycleImages[index] = imageName;
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        protected int deliveryValueOf(DeliveryClass delivery) {
            return Utilities.getTileDelivery(delivery);
        }

        @Override
        public CycleTileNotification build() {
            return new CycleTileNotification(this, this.headers);
        }

        protected byte[] toByteArray() {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            sb.append("<wp:Notification xmlns:wp=\"WPNotification\">");
            sb.append("<wp:Tile");
            if (this.tileId != null) {
                sb.append(" Id=\"");
                sb.append(this.tileId);
                sb.append("\"");
            }
            sb.append(" Template=\"CycleTile\">");
            if (this.isClear) {
                sb.append(Utilities.xmlElementClear("SmallBackgroundImage", this.smallBackgroundImage));
            } else {
                sb.append(Utilities.xmlElement("SmallBackgroundImage", this.smallBackgroundImage));
            }
            for (int i = 0; i < 9; ++i) {
                if (this.cycleImages[i] == null) continue;
                sb.append(Utilities.xmlElementClear("CycleImage" + (i + 1), this.cycleImages[i]));
            }
            sb.append(Utilities.xmlElementClear("Count", "" + this.count));
            sb.append(Utilities.xmlElementClear("Title", this.title));
            sb.append("</wp:Tile>");
            sb.append("</wp:Notification>");
            return Utilities.toUTF8(sb.toString());
        }
    }
}

