/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.internal;

import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jboss.aerogear.windows.mpns.MpnsDelegate;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.MpnsService;
import org.jboss.aerogear.windows.mpns.internal.AbstractMpnsService;
import org.jboss.aerogear.windows.mpns.internal.Utilities;

public class MpnsPooledService
extends AbstractMpnsService
implements MpnsService {
    private final HttpClient httpClient;
    private final ExecutorService executor;
    private final MpnsDelegate delegate;

    public MpnsPooledService(HttpClient httpClient, ExecutorService executor, MpnsDelegate delegate) {
        this.httpClient = httpClient;
        this.executor = executor;
        this.delegate = delegate;
    }

    @Override
    protected void push(final HttpPost request, final MpnsNotification message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpResponse response = MpnsPooledService.this.httpClient.execute((HttpUriRequest)request);
                    Utilities.fireDelegate(message, response, MpnsPooledService.this.delegate);
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void stop() {
        super.stop();
        this.httpClient.getConnectionManager().shutdown();
        this.executor.shutdown();
    }
}

