/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class CacheExpirationFilter
extends GenericFilterBean {
    private static final long YEAR_OF_MILLISECONDS = 31536000000L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String cachedControlString;
    private long cacheMaxAge = 31536000000L;

    public int getCacheMaxAge() {
        return (int)(this.cacheMaxAge / 1000L);
    }

    public void setCacheMaxAge(int cacheMaxAge) {
        if (cacheMaxAge < 1) {
            throw new IllegalArgumentException("Specified initParamter 'cacheMaxAge' must be greater than 0, (" + cacheMaxAge + ")");
        }
        this.cacheMaxAge = cacheMaxAge * 1000;
        this.updateHeaders();
    }

    protected void initFilterBean() throws ServletException {
        this.updateHeaders();
    }

    private void updateHeaders() {
        this.cachedControlString = "public, max-age=" + this.cacheMaxAge / 1000L;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse && request instanceof HttpServletRequest) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setDateHeader("Expires", this.cacheMaxAge + System.currentTimeMillis());
            httpResponse.setHeader("Cache-Control", this.cachedControlString);
        }
        chain.doFilter(request, response);
    }
}

