/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.HashSet;
import org.jacoco.asm.tree.AbstractInsnNode;
import org.jacoco.asm.tree.JumpInsnNode;
import org.jacoco.asm.tree.LabelNode;
import org.jacoco.asm.tree.LookupSwitchInsnNode;
import org.jacoco.asm.tree.MethodNode;
import org.jacoco.asm.tree.TableSwitchInsnNode;
import org.jacoco.asm.tree.VarInsnNode;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;

public final class StringSwitchEcjFilter
implements IFilter {
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            matcher.match(i, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(AbstractInsnNode start, IFilterOutput output) {
            int hashCodes;
            LabelNode defaultLabel;
            if (58 != start.getOpcode()) {
                return;
            }
            this.cursor = start;
            this.nextIsInvoke(182, "java/lang/String", "hashCode", "()I");
            this.nextIsSwitch();
            if (this.cursor == null) {
                return;
            }
            this.vars.put("s", (VarInsnNode)start);
            AbstractInsnNode s = this.cursor;
            if (s.getOpcode() == 171) {
                LookupSwitchInsnNode lookupSwitch = (LookupSwitchInsnNode)this.cursor;
                defaultLabel = lookupSwitch.dflt;
                hashCodes = lookupSwitch.labels.size();
            } else {
                TableSwitchInsnNode tableSwitch = (TableSwitchInsnNode)this.cursor;
                defaultLabel = tableSwitch.dflt;
                hashCodes = tableSwitch.labels.size();
            }
            HashSet<AbstractInsnNode> replacements = new HashSet<AbstractInsnNode>();
            replacements.add(Matcher.skipNonOpcodes(defaultLabel));
            block0: for (int i = 0; i < hashCodes; ++i) {
                do {
                    this.nextIsVar(25, "s");
                    this.nextIs(18);
                    this.nextIsInvoke(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                    this.nextIs(154);
                    if (this.cursor == null) {
                        return;
                    }
                    replacements.add(Matcher.skipNonOpcodes(((JumpInsnNode)this.cursor).label));
                    if (this.cursor.getNext().getOpcode() != 167) continue;
                    this.nextIs(167);
                    continue block0;
                } while (this.cursor.getNext() != defaultLabel);
            }
            output.ignore(s.getNext(), this.cursor);
            output.replaceBranches(s, replacements);
        }
    }
}

