/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreConfiguration;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;

public class TrustStoreConfigurationBuilder
implements Builder<TrustStoreConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;
    private TrustManagerFactory trustManagerFactory;
    private KeyStore trustStore;

    TrustStoreConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = TrustStoreConfiguration.attributeDefinitionSet();
    }

    public TrustStoreConfigurationBuilder password(char[] password) {
        this.attributes.attribute(TrustStoreConfiguration.PASSWORD).set((Object)password);
        return this;
    }

    public TrustStoreConfigurationBuilder path(String path) {
        this.attributes.attribute(TrustStoreConfiguration.PATH).set((Object)path);
        return this;
    }

    public TrustStoreConfigurationBuilder provider(String value) {
        this.attributes.attribute(TrustStoreConfiguration.PROVIDER).set((Object)value);
        return this;
    }

    public TrustStoreConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(TrustStoreConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public void build() {
        if (this.trustManagerFactory == null) {
            String fileName = ParseUtils.resolvePath((String)((String)this.attributes.attribute(TrustStoreConfiguration.PATH).get()), (String)((String)this.attributes.attribute(TrustStoreConfiguration.RELATIVE_TO).get()));
            String provider = (String)this.attributes.attribute(TrustStoreConfiguration.PROVIDER).get();
            char[] password = (char[])this.attributes.attribute(TrustStoreConfiguration.PASSWORD).get();
            try (FileInputStream is = new FileInputStream(fileName);){
                this.trustStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, (String)provider, (FileInputStream)is, (String)fileName, (char[])password);
                this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.trustManagerFactory.init(this.trustStore);
                for (TrustManager trustManager : this.trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    this.realmBuilder.sslContextBuilder().setTrustManager((X509TrustManager)trustManager);
                    return;
                }
                throw Server.log.noDefaultTrustManager();
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        }
    }

    public KeyStore trustStore() {
        this.build();
        return this.trustStore;
    }

    public void validate() {
    }

    public TrustStoreConfiguration create() {
        return new TrustStoreConfiguration(this.attributes.protect());
    }

    public TrustStoreConfigurationBuilder read(TrustStoreConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

