/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.LdapAttributeConfiguration;
import org.infinispan.server.configuration.security.LdapAttributeMappingConfiguration;
import org.infinispan.server.configuration.security.LdapAttributeMappingConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfiguration;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfigurationBuilder;

public class LdapIdentityMappingConfigurationBuilder
implements Builder<LdapIdentityMappingConfiguration> {
    private final AttributeSet attributes;
    private final List<LdapAttributeMappingConfigurationBuilder> attributeMappings = new ArrayList<LdapAttributeMappingConfigurationBuilder>();
    private final List<LdapUserPasswordMapperConfigurationBuilder> userPasswordMapper = new ArrayList<LdapUserPasswordMapperConfigurationBuilder>();
    private final LdapRealmConfigurationBuilder ldapConfigurationBuilder;

    LdapIdentityMappingConfigurationBuilder(LdapRealmConfigurationBuilder ldapConfigurationBuilder) {
        this.ldapConfigurationBuilder = ldapConfigurationBuilder;
        this.attributes = LdapIdentityMappingConfiguration.attributeDefinitionSet();
    }

    public LdapIdentityMappingConfigurationBuilder rdnIdentifier(String rdnIdentifier) {
        this.attributes.attribute(LdapIdentityMappingConfiguration.RDN_IDENTIFIER).set((Object)rdnIdentifier);
        this.ldapConfigurationBuilder.getIdentityMappingBuilder().setRdnIdentifier(rdnIdentifier);
        return this;
    }

    public LdapIdentityMappingConfigurationBuilder searchBaseDn(String searchBaseDn) {
        this.attributes.attribute(LdapIdentityMappingConfiguration.SEARCH_BASE_DN).set((Object)searchBaseDn);
        this.ldapConfigurationBuilder.getIdentityMappingBuilder().setSearchDn(searchBaseDn);
        return this;
    }

    public LdapIdentityMappingConfigurationBuilder searchRecursive(boolean searchRecursive) {
        this.attributes.attribute(LdapAttributeConfiguration.SEARCH_RECURSIVE).set((Object)searchRecursive);
        if (searchRecursive) {
            this.ldapConfigurationBuilder.getIdentityMappingBuilder().searchRecursive();
        }
        return this;
    }

    public LdapIdentityMappingConfigurationBuilder filterName(String filterName) {
        this.attributes.attribute(LdapIdentityMappingConfiguration.FILTER_NAME).set((Object)filterName);
        this.ldapConfigurationBuilder.getIdentityMappingBuilder().setFilterName(filterName);
        return this;
    }

    public LdapAttributeMappingConfigurationBuilder addAttributeMapping() {
        LdapAttributeMappingConfigurationBuilder builder = new LdapAttributeMappingConfigurationBuilder(this.ldapConfigurationBuilder);
        this.attributeMappings.add(builder);
        return builder;
    }

    public LdapUserPasswordMapperConfigurationBuilder addUserPasswordMapper() {
        LdapUserPasswordMapperConfigurationBuilder builder = new LdapUserPasswordMapperConfigurationBuilder(this.ldapConfigurationBuilder);
        this.userPasswordMapper.add(builder);
        return builder;
    }

    public void validate() {
        this.attributeMappings.forEach(LdapAttributeMappingConfigurationBuilder::validate);
        this.userPasswordMapper.forEach(LdapUserPasswordMapperConfigurationBuilder::validate);
    }

    public LdapIdentityMappingConfiguration create() {
        List<LdapAttributeMappingConfiguration> mappingConfigurations = this.attributeMappings.stream().map(LdapAttributeMappingConfigurationBuilder::create).collect(Collectors.toList());
        List<LdapUserPasswordMapperConfiguration> userPasswordMapperConfigurations = this.userPasswordMapper.stream().map(LdapUserPasswordMapperConfigurationBuilder::create).collect(Collectors.toList());
        return new LdapIdentityMappingConfiguration(this.attributes.protect(), mappingConfigurations, userPasswordMapperConfigurations);
    }

    public LdapIdentityMappingConfigurationBuilder read(LdapIdentityMappingConfiguration template) {
        this.attributes.read(template.attributes());
        this.attributeMappings.clear();
        this.userPasswordMapper.clear();
        template.attributeMappings().forEach(a -> this.addAttributeMapping().read((LdapAttributeMappingConfiguration)a));
        template.userPasswordMapper().forEach(a -> this.addUserPasswordMapper().read((LdapUserPasswordMapperConfiguration)a));
        return this;
    }
}

