/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.configuration.security.CredentialStoresConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmsConfigurationBuilder;
import org.infinispan.server.configuration.security.SecurityConfiguration;

public class SecurityConfigurationBuilder
implements Builder<SecurityConfiguration> {
    private final CredentialStoresConfigurationBuilder credentialStoresConfiguration = new CredentialStoresConfigurationBuilder();
    private final RealmsConfigurationBuilder realmsConfiguration = new RealmsConfigurationBuilder();

    public CredentialStoresConfigurationBuilder credentialStores() {
        return this.credentialStoresConfiguration;
    }

    public RealmsConfigurationBuilder realms() {
        return this.realmsConfiguration;
    }

    public void validate() {
        this.credentialStoresConfiguration.validate();
        this.realmsConfiguration.validate();
    }

    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.credentialStoresConfiguration.create(), this.realmsConfiguration.create());
    }

    public SecurityConfigurationBuilder read(SecurityConfiguration template) {
        this.credentialStoresConfiguration.read(template.credentialStores());
        this.realmsConfiguration.read(template.realms());
        return this;
    }
}

