/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.CredentialStoreConfiguration;
import org.infinispan.server.configuration.security.CredentialStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.wildfly.security.credential.Credential;

public class CredentialStoresConfigurationBuilder
implements Builder<CredentialStoresConfiguration> {
    private final AttributeSet attributes;
    private final Map<String, CredentialStoreConfigurationBuilder> credentialStores = new LinkedHashMap<String, CredentialStoreConfigurationBuilder>(2);

    public CredentialStoresConfigurationBuilder() {
        this.attributes = CredentialStoresConfiguration.attributeDefinitionSet();
    }

    public CredentialStoreConfigurationBuilder addCredentialStore(String name) {
        CredentialStoreConfigurationBuilder credentialStoreBuilder = new CredentialStoreConfigurationBuilder(this);
        this.credentialStores.put(name, credentialStoreBuilder);
        return credentialStoreBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <C extends Credential> C getCredential(String store, String alias, Class<C> type) {
        CredentialStoreConfigurationBuilder credentialStoreConfigurationBuilder;
        if (store == null) {
            if (this.credentialStores.size() != 1) throw Server.log.missingCredentialStoreName();
            credentialStoreConfigurationBuilder = this.credentialStores.values().iterator().next();
        } else {
            credentialStoreConfigurationBuilder = this.credentialStores.get(store);
        }
        if (credentialStoreConfigurationBuilder == null) {
            throw Server.log.unknownCredentialStore(store);
        }
        C credential = credentialStoreConfigurationBuilder.getCredential(alias, type);
        if (credential != null) return credential;
        throw Server.log.unknownCredential(alias, store);
    }

    public void validate() {
    }

    public CredentialStoresConfiguration create() {
        List<CredentialStoreConfiguration> list = this.credentialStores.values().stream().map(CredentialStoreConfigurationBuilder::create).collect(Collectors.toList());
        return new CredentialStoresConfiguration(this.attributes.protect(), list);
    }

    public Builder<?> read(CredentialStoresConfiguration template) {
        return this;
    }
}

