/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class PathInterpreter {
    PathInterpreter() {
    }

    static Map<String, String> resolveVariables(String expression, String str) {
        if (expression == null || str == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> resolvedVariables = new HashMap<String, String>();
        StringBuilder variableBuilder = new StringBuilder();
        State state = State.TEXT;
        int j = 0;
        int expressionLength = expression.length();
        block9: for (int i = 0; i < expressionLength; ++i) {
            char e = expression.charAt(i);
            switch (e) {
                case '{': {
                    if (state == State.END_VAR) {
                        return Collections.emptyMap();
                    }
                    state = State.VAR;
                    continue block9;
                }
                case '}': {
                    if (state != State.VAR) {
                        return Collections.emptyMap();
                    }
                    state = State.END_VAR;
                    if (i != expressionLength - 1) continue block9;
                }
                default: {
                    switch (state) {
                        case VAR: {
                            variableBuilder.append(e);
                            continue block9;
                        }
                        case END_VAR: {
                            String replacement;
                            boolean ec;
                            boolean bl = ec = i == expressionLength - 1;
                            if (ec) {
                                replacement = str.substring(j);
                            } else {
                                int k = str.indexOf(e, j);
                                if (k == -1) {
                                    return Collections.emptyMap();
                                }
                                replacement = str.substring(j, str.indexOf(e, j));
                            }
                            resolvedVariables.put(variableBuilder.toString(), replacement);
                            if ((j += replacement.length()) == str.length() && ec) {
                                return resolvedVariables;
                            }
                            variableBuilder.setLength(0);
                            state = State.TEXT;
                        }
                        case TEXT: {
                            if (str.charAt(j) != e) {
                                return Collections.emptyMap();
                            }
                            ++j;
                        }
                    }
                }
            }
        }
        return resolvedVariables;
    }

    static enum State {
        VAR,
        END_VAR,
        TEXT;

    }
}

