/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.InputStream;
import java.util.Iterator;
import java.util.stream.Stream;
import org.infinispan.CacheStream;

public class CacheKeyInputStream
extends InputStream {
    private static final char STREAM_OPEN_CHAR = '[';
    private static final char SEPARATOR = ',';
    private static final char STREAM_CLOSE_CHAR = ']';
    private final Iterator<?> iterator;
    private final Stream<?> stream;
    private final int batchSize;
    private byte[] currentEntry;
    private int cursor = 0;
    private Boolean hasNext;
    private State state = State.BEGIN;

    public CacheKeyInputStream(CacheStream<?> stream, int batchSize) {
        this.batchSize = batchSize;
        this.stream = stream.distributedBatchSize(batchSize);
        this.iterator = stream.iterator();
        this.hasNext = this.iterator.hasNext();
    }

    @Override
    public int available() {
        return this.currentEntry == null ? 0 : this.currentEntry.length - this.cursor * this.batchSize;
    }

    @Override
    public synchronized int read() {
        block6: while (true) {
            switch (this.state) {
                case BEGIN: {
                    this.state = this.hasNext != false ? State.ITEM : State.END;
                    return 91;
                }
                case SEPARATOR: {
                    if (this.hasNext.booleanValue()) {
                        this.state = State.ITEM;
                        return 44;
                    }
                    this.state = State.END;
                    continue block6;
                }
                case END: {
                    this.state = State.EOF;
                    this.stream.close();
                    return 93;
                }
                case ITEM: {
                    int c;
                    if (this.currentEntry == null && this.hasNext.booleanValue()) {
                        this.currentEntry = (byte[])this.iterator.next();
                    }
                    int n = c = this.currentEntry == null || this.cursor == this.currentEntry.length ? -1 : this.currentEntry[this.cursor++] & 0xFF;
                    if (c != -1) {
                        return c;
                    }
                    this.hasNext = this.iterator.hasNext();
                    this.cursor = 0;
                    this.currentEntry = null;
                    this.state = State.SEPARATOR;
                    continue block6;
                }
            }
            break;
        }
        return -1;
    }

    private static enum State {
        BEGIN,
        ITEM,
        SEPARATOR,
        END,
        EOF;

    }
}

