/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.infinispan.Cache;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.scripting.impl.SecurityActions;

class DistributedScript<T>
implements DistributedCallable<Object, Object, T>,
Serializable {
    private final ScriptMetadata metadata;
    private final Map<String, ?> ctxParams;
    private transient ScriptingManagerImpl scriptManager;
    private transient Bindings bindings;

    DistributedScript(ScriptMetadata metadata, Map<String, ?> ctxParams) {
        this.metadata = metadata;
        this.ctxParams = ctxParams;
    }

    public T call() throws Exception {
        return this.scriptManager.execute(this.metadata, this.bindings).get();
    }

    public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
        this.scriptManager = (ScriptingManagerImpl)SecurityActions.getGlobalComponentRegistry(cache.getCacheManager()).getComponent(ScriptingManager.class);
        this.bindings = new SimpleBindings();
        this.bindings.put("inputKeys", (Object)inputKeys);
        String scriptMediaType = this.metadata.dataType().toString();
        DataTypedCacheManager dataTypedCacheManager = new DataTypedCacheManager(scriptMediaType, cache.getCacheManager(), null);
        this.bindings.put("cacheManager", (Object)dataTypedCacheManager);
        this.bindings.put("cache", (Object)cache.getAdvancedCache().withMediaType(scriptMediaType, scriptMediaType));
        this.ctxParams.forEach((key, value) -> this.bindings.put((String)key, value));
    }
}

