/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.scripting.impl.DataType;
import org.infinispan.scripting.impl.ExecutionMode;
import org.infinispan.scripting.impl.ExternalizerIds;

public class ScriptMetadata
implements Metadata {
    private final String name;
    private final ExecutionMode mode;
    private final String extension;
    private final Set<String> parameters;
    private final Optional<String> language;
    private final Optional<String> role;
    private final Optional<String> reducer;
    private final Optional<String> collator;
    private final Optional<String> combiner;
    private final DataType dataType;

    ScriptMetadata(String name, Optional<String> language, String extension, ExecutionMode mode, Set<String> parameters, Optional<String> role, Optional<String> reducer, Optional<String> collator, Optional<String> combiner, DataType dataType) {
        this.name = name;
        this.language = language;
        this.extension = extension;
        this.mode = mode;
        this.parameters = Collections.unmodifiableSet(parameters);
        this.role = role;
        this.reducer = reducer;
        this.collator = collator;
        this.combiner = combiner;
        this.dataType = dataType;
    }

    public Optional<String> language() {
        return this.language;
    }

    public String extension() {
        return this.extension;
    }

    public Set<String> parameters() {
        return this.parameters;
    }

    public Optional<String> role() {
        return this.role;
    }

    public String name() {
        return this.name;
    }

    public ExecutionMode mode() {
        return this.mode;
    }

    public Optional<String> reducer() {
        return this.reducer;
    }

    public Optional<String> combiner() {
        return this.combiner;
    }

    public Optional<String> collator() {
        return this.collator;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public long lifespan() {
        return -1L;
    }

    public long maxIdle() {
        return -1L;
    }

    public EntryVersion version() {
        return null;
    }

    public Builder builder() {
        return new Builder().name(this.name).extension(this.extension).mode(this.mode).parameters(this.parameters);
    }

    public String toString() {
        return "ScriptMetadata [name=" + this.name + ", language=" + this.language + ", mode=" + (Object)((Object)this.mode) + ", extension=" + this.extension + ", parameters=" + this.parameters + ", role=" + this.role + ", reducer=" + this.reducer + ", collator=" + this.collator + ", combiner=" + this.combiner + "]";
    }

    public static class Externalizer
    extends AbstractExternalizer<ScriptMetadata> {
        private static final long serialVersionUID = 6882540247700043640L;

        public Integer getId() {
            return ExternalizerIds.SCRIPT_METADATA;
        }

        public Set<Class<? extends ScriptMetadata>> getTypeClasses() {
            return Collections.singleton(ScriptMetadata.class);
        }

        public void writeObject(ObjectOutput output, ScriptMetadata object) throws IOException {
            output.writeUTF(object.name);
            output.writeUTF(object.extension);
            output.writeUTF(object.mode.name());
            output.writeObject(object.parameters);
            output.writeObject(object.language);
            output.writeObject(object.role);
            output.writeObject(object.reducer);
            output.writeObject(object.collator);
            output.writeObject(object.combiner);
            output.writeObject((Object)object.dataType);
        }

        public ScriptMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String name = input.readUTF();
            String extension = input.readUTF();
            ExecutionMode mode = ExecutionMode.valueOf(input.readUTF());
            Set parameters = (Set)input.readObject();
            Optional language = (Optional)input.readObject();
            Optional role = (Optional)input.readObject();
            Optional reducer = (Optional)input.readObject();
            Optional collator = (Optional)input.readObject();
            Optional combiner = (Optional)input.readObject();
            DataType dataType = (DataType)((Object)input.readObject());
            return new ScriptMetadata(name, language, extension, mode, parameters, role, reducer, collator, combiner, dataType);
        }
    }

    public static class Builder
    implements Metadata.Builder {
        String name;
        String extension;
        Optional<String> language = Optional.empty();
        ExecutionMode mode;
        Set<String> parameters = Collections.emptySet();
        Optional<String> role = Optional.empty();
        Optional<String> combiner = Optional.empty();
        Optional<String> collator = Optional.empty();
        Optional<String> reducer = Optional.empty();
        DataType dataType = DataType.DEFAULT;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mode(ExecutionMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder language(String language) {
            this.language = Optional.of(language);
            return this;
        }

        public Builder parameters(Set<String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder role(String role) {
            this.role = Optional.of(role);
            return this;
        }

        public Builder reducer(String reducer) {
            this.reducer = Optional.of(reducer);
            return this;
        }

        public Builder collator(String collator) {
            this.collator = Optional.of(collator);
            return this;
        }

        public Builder combiner(String combiner) {
            this.combiner = Optional.of(combiner);
            return this;
        }

        public Builder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder lifespan(long time, TimeUnit unit) {
            return this;
        }

        public Builder lifespan(long time) {
            return this;
        }

        public Builder maxIdle(long time, TimeUnit unit) {
            return this;
        }

        public Builder maxIdle(long time) {
            return this;
        }

        public Builder version(EntryVersion version) {
            return this;
        }

        public ScriptMetadata build() {
            return new ScriptMetadata(this.name, this.language, this.extension, this.mode, this.parameters, this.role, this.reducer, this.collator, this.combiner, this.dataType);
        }

        public Builder merge(Metadata metadata) {
            return this;
        }
    }
}

