/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.infinispan.query.dsl.IndexedQueryMode;

public class JsonQueryRequest {
    private static final Integer DEFAULT_OFFSET = 0;
    private static final Integer DEFAULT_MAX_RESULTS = 10;
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="offset")
    private final Integer startOffset;
    @JsonProperty(value="max_results")
    private final Integer maxResults;
    @JsonProperty(value="query_mode")
    private IndexedQueryMode queryMode;

    public JsonQueryRequest(String query, Integer startOffset, Integer maxResults, IndexedQueryMode queryMode) {
        this.query = query;
        this.startOffset = startOffset == null ? DEFAULT_OFFSET : startOffset;
        this.maxResults = maxResults == null ? DEFAULT_MAX_RESULTS : maxResults;
        this.queryMode = queryMode;
    }

    private JsonQueryRequest(String query) {
        this(query, DEFAULT_OFFSET, DEFAULT_MAX_RESULTS, IndexedQueryMode.FETCH);
    }

    private JsonQueryRequest() {
        this("");
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getStartOffset() {
        return this.startOffset;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public IndexedQueryMode getQueryMode() {
        return this.queryMode;
    }
}

