/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.BaseRemoteQueryManager;
import org.infinispan.query.remote.impl.ObjectReflectionMatcher;
import org.infinispan.query.remote.impl.ObjectRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufEntityNameResolver;
import org.infinispan.query.remote.impl.ProtobufObjectReflectionMatcher;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.SecurityActions;

class ObjectRemoteQueryManager
extends BaseRemoteQueryManager {
    private final Map<String, BaseRemoteQueryEngine> enginePerMediaType = new ConcurrentHashMap<String, BaseRemoteQueryEngine>();
    protected final SerializationContext serCtx;
    protected final boolean isIndexed;
    private final ComponentRegistry cr;

    ObjectRemoteQueryManager(ComponentRegistry cr, QuerySerializers querySerializers) {
        super(cr, querySerializers);
        this.cr = cr;
        this.isIndexed = this.cache.getCacheConfiguration().indexing().index().isEnabled();
        this.serCtx = SecurityActions.getSerializationContext(this.cache.getCacheManager());
    }

    @Override
    public Class<? extends Matcher> getMatcherClass(MediaType mediaType) {
        return this.getQueryEngineForMediaType(mediaType).getMatcherClass();
    }

    @Override
    public BaseRemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return this.getQueryEngineForMediaType(cache.getValueDataConversion().getRequestMediaType());
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return filterResult;
    }

    private BaseRemoteQueryEngine getQueryEngineForMediaType(MediaType mediaType) {
        BaseRemoteQueryEngine queryEngine = this.enginePerMediaType.get(mediaType.getTypeSubtype());
        if (queryEngine != null) {
            return queryEngine;
        }
        SearchIntegrator searchIntegrator = (SearchIntegrator)this.cr.getComponent(SearchIntegrator.class);
        ClassLoader classLoader = (ClassLoader)this.cr.getGlobalComponentRegistry().getComponent(ClassLoader.class);
        EntityNameResolver entityNameResolver = this.createEntityNamesResolver(mediaType, classLoader);
        ObjectReflectionMatcher matcher = mediaType.match(MediaType.APPLICATION_PROTOSTREAM) ? ProtobufObjectReflectionMatcher.create(entityNameResolver, this.serCtx, searchIntegrator, classLoader) : ObjectReflectionMatcher.create(entityNameResolver, searchIntegrator, classLoader);
        this.cr.registerComponent((Object)matcher, ((Object)((Object)matcher)).getClass());
        ObjectRemoteQueryEngine engine = new ObjectRemoteQueryEngine(this.cache, ((Object)((Object)matcher)).getClass(), this.isIndexed);
        this.enginePerMediaType.put(mediaType.getTypeSubtype(), engine);
        return engine;
    }

    private EntityNameResolver createEntityNamesResolver(MediaType mediaType, ClassLoader classLoader) {
        if (mediaType.match(MediaType.APPLICATION_PROTOSTREAM)) {
            return new ProtobufEntityNameResolver(this.serCtx);
        }
        ReflectionEntityNamesResolver reflectionEntityNamesResolver = new ReflectionEntityNamesResolver(classLoader);
        if (this.isIndexed) {
            QueryInterceptor qi = (QueryInterceptor)this.cr.getComponent(QueryInterceptor.class);
            return name -> qi.getKnownClasses().stream().filter(c -> c.getName().equals(name)).findFirst().orElse(reflectionEntityNamesResolver.resolve(name));
        }
        return reflectionEntityNamesResolver;
    }
}

