/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.continuous.impl.IckleContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.remote.client.ContinuousQueryResult;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.RemoteQueryManager;

public final class IckleContinuousQueryProtobufCacheEventFilterConverter
extends IckleContinuousQueryCacheEventFilterConverter<Object, Object, Object> {
    private RemoteQueryManager remoteQueryManager;

    IckleContinuousQueryProtobufCacheEventFilterConverter(String queryString, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        super(queryString, namedParameters, matcherImplClass);
    }

    protected void injectDependencies(Cache cache) {
        this.remoteQueryManager = (RemoteQueryManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RemoteQueryManager.class);
        this.matcherImplClass = this.remoteQueryManager.getMatcherClass(MediaType.APPLICATION_PROTOSTREAM);
        super.injectDependencies(cache);
    }

    public Object filterAndConvert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
        ObjectFilter.FilterResult f2;
        if (eventType.isExpired()) {
            oldValue = newValue;
            newValue = null;
        }
        ObjectFilter objectFilter = this.getObjectFilter();
        ObjectFilter.FilterResult f1 = oldValue == null ? null : objectFilter.filter(oldValue);
        ObjectFilter.FilterResult filterResult = f2 = newValue == null ? null : objectFilter.filter(newValue);
        if (f1 == null && f2 != null) {
            return this.makeFilterResult(ContinuousQueryResult.ResultType.JOINING, key, f2.getProjection() == null ? newValue : null, f2.getProjection());
        }
        if (f1 != null && f2 == null) {
            return this.makeFilterResult(ContinuousQueryResult.ResultType.LEAVING, key, null, null);
        }
        return null;
    }

    private Object makeFilterResult(ContinuousQueryResult.ResultType resultType, Object key, Object value, Object[] projection) {
        key = this.remoteQueryManager.convertKey(key, MediaType.APPLICATION_PROTOSTREAM);
        if (value != null) {
            value = this.remoteQueryManager.convertValue(value, MediaType.APPLICATION_PROTOSTREAM);
        }
        ContinuousQueryResult result = new ContinuousQueryResult(resultType, (byte[])key, (byte[])value, projection);
        return this.remoteQueryManager.encodeFilterResult(result);
    }

    public String toString() {
        return "IckleContinuousQueryProtobufCacheEventFilterConverter{queryString='" + this.queryString + "'}";
    }

    public static final class Externalizer
    extends AbstractExternalizer<IckleContinuousQueryProtobufCacheEventFilterConverter> {
        public void writeObject(ObjectOutput output, IckleContinuousQueryProtobufCacheEventFilterConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.queryString);
            Map namedParameters = filterAndConverter.namedParameters;
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public IckleContinuousQueryProtobufCacheEventFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String queryString = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            Class matcherImplClass = (Class)input.readObject();
            return new IckleContinuousQueryProtobufCacheEventFilterConverter(queryString, namedParameters, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER;
        }

        public Set<Class<? extends IckleContinuousQueryProtobufCacheEventFilterConverter>> getTypeClasses() {
            return Collections.singleton(IckleContinuousQueryProtobufCacheEventFilterConverter.class);
        }
    }
}

