/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.AccessHint;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ColumnFamilyOptionsInterface;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.DbPath;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Logger;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.MutableColumnFamilyOptionsInterface;
import org.rocksdb.RateLimiter;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WALRecoveryMode;

public class Options
extends RocksObject
implements DBOptionsInterface<Options>,
ColumnFamilyOptionsInterface<Options>,
MutableColumnFamilyOptionsInterface<Options> {
    private Env env_ = Env.getDefault();
    private MemTableConfig memTableConfig_;
    private TableFormatConfig tableFormatConfig_;
    private RateLimiter rateLimiter_;
    private AbstractComparator<? extends AbstractSlice<?>> comparator_;
    private CompactionOptionsUniversal compactionOptionsUniversal_;
    private CompactionOptionsFIFO compactionOptionsFIFO_;
    private CompressionOptions compressionOptions_;
    private Cache rowCache_;

    public Options() {
        super(Options.newOptions());
    }

    public Options(DBOptions dBOptions, ColumnFamilyOptions columnFamilyOptions) {
        super(Options.newOptions(dBOptions.nativeHandle_, columnFamilyOptions.nativeHandle_));
    }

    @Override
    public Options setIncreaseParallelism(int n) {
        assert (this.isOwningHandle());
        this.setIncreaseParallelism(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options setCreateIfMissing(boolean bl) {
        assert (this.isOwningHandle());
        this.setCreateIfMissing(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public Options setCreateMissingColumnFamilies(boolean bl) {
        assert (this.isOwningHandle());
        this.setCreateMissingColumnFamilies(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public Options setEnv(Env env) {
        assert (this.isOwningHandle());
        this.setEnv(this.nativeHandle_, env.nativeHandle_);
        this.env_ = env;
        return this;
    }

    @Override
    public Env getEnv() {
        return this.env_;
    }

    public Options prepareForBulkLoad() {
        this.prepareForBulkLoad(this.nativeHandle_);
        return this;
    }

    @Override
    public boolean createIfMissing() {
        assert (this.isOwningHandle());
        return this.createIfMissing(this.nativeHandle_);
    }

    @Override
    public boolean createMissingColumnFamilies() {
        assert (this.isOwningHandle());
        return this.createMissingColumnFamilies(this.nativeHandle_);
    }

    @Override
    public Options optimizeForSmallDb() {
        this.optimizeForSmallDb(this.nativeHandle_);
        return this;
    }

    @Override
    public Options optimizeForPointLookup(long l) {
        this.optimizeForPointLookup(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction() {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction(long l) {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction() {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction(long l) {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options setComparator(BuiltinComparator builtinComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, builtinComparator.ordinal());
        return this;
    }

    @Override
    public Options setComparator(AbstractComparator<? extends AbstractSlice<?>> abstractComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, abstractComparator.getNativeHandle());
        this.comparator_ = abstractComparator;
        return this;
    }

    @Override
    public Options setMergeOperatorName(String string) {
        assert (this.isOwningHandle());
        if (string == null) {
            throw new IllegalArgumentException("Merge operator name must not be null.");
        }
        this.setMergeOperatorName(this.nativeHandle_, string);
        return this;
    }

    @Override
    public Options setMergeOperator(MergeOperator mergeOperator) {
        this.setMergeOperator(this.nativeHandle_, mergeOperator.nativeHandle_);
        return this;
    }

    @Override
    public Options setWriteBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setWriteBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeBufferSize() {
        assert (this.isOwningHandle());
        return this.writeBufferSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxWriteBufferNumber(int n) {
        assert (this.isOwningHandle());
        this.setMaxWriteBufferNumber(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxWriteBufferNumber() {
        assert (this.isOwningHandle());
        return this.maxWriteBufferNumber(this.nativeHandle_);
    }

    @Override
    public boolean errorIfExists() {
        assert (this.isOwningHandle());
        return this.errorIfExists(this.nativeHandle_);
    }

    @Override
    public Options setErrorIfExists(boolean bl) {
        assert (this.isOwningHandle());
        this.setErrorIfExists(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean paranoidChecks() {
        assert (this.isOwningHandle());
        return this.paranoidChecks(this.nativeHandle_);
    }

    @Override
    public Options setParanoidChecks(boolean bl) {
        assert (this.isOwningHandle());
        this.setParanoidChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public int maxOpenFiles() {
        assert (this.isOwningHandle());
        return this.maxOpenFiles(this.nativeHandle_);
    }

    @Override
    public Options setMaxFileOpeningThreads(int n) {
        assert (this.isOwningHandle());
        this.setMaxFileOpeningThreads(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxFileOpeningThreads() {
        assert (this.isOwningHandle());
        return this.maxFileOpeningThreads(this.nativeHandle_);
    }

    @Override
    public Options setMaxTotalWalSize(long l) {
        assert (this.isOwningHandle());
        this.setMaxTotalWalSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxTotalWalSize() {
        assert (this.isOwningHandle());
        return this.maxTotalWalSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxOpenFiles(int n) {
        assert (this.isOwningHandle());
        this.setMaxOpenFiles(this.nativeHandle_, n);
        return this;
    }

    @Override
    public boolean useFsync() {
        assert (this.isOwningHandle());
        return this.useFsync(this.nativeHandle_);
    }

    @Override
    public Options setUseFsync(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseFsync(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public Options setDbPaths(Collection<DbPath> collection) {
        assert (this.isOwningHandle());
        int n = collection.size();
        String[] stringArray = new String[n];
        long[] lArray = new long[n];
        int n2 = 0;
        for (DbPath dbPath : collection) {
            stringArray[n2] = dbPath.path.toString();
            lArray[n2] = dbPath.targetSize;
            ++n2;
        }
        this.setDbPaths(this.nativeHandle_, stringArray, lArray);
        return this;
    }

    @Override
    public List<DbPath> dbPaths() {
        int n = (int)this.dbPathsLen(this.nativeHandle_);
        if (n == 0) {
            return Collections.emptyList();
        }
        String[] stringArray = new String[n];
        long[] lArray = new long[n];
        this.dbPaths(this.nativeHandle_, stringArray, lArray);
        ArrayList<DbPath> arrayList = new ArrayList<DbPath>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new DbPath(Paths.get(stringArray[i], new String[0]), lArray[i]));
        }
        return arrayList;
    }

    @Override
    public String dbLogDir() {
        assert (this.isOwningHandle());
        return this.dbLogDir(this.nativeHandle_);
    }

    @Override
    public Options setDbLogDir(String string) {
        assert (this.isOwningHandle());
        this.setDbLogDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public String walDir() {
        assert (this.isOwningHandle());
        return this.walDir(this.nativeHandle_);
    }

    @Override
    public Options setWalDir(String string) {
        assert (this.isOwningHandle());
        this.setWalDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public long deleteObsoleteFilesPeriodMicros() {
        assert (this.isOwningHandle());
        return this.deleteObsoleteFilesPeriodMicros(this.nativeHandle_);
    }

    @Override
    public Options setDeleteObsoleteFilesPeriodMicros(long l) {
        assert (this.isOwningHandle());
        this.setDeleteObsoleteFilesPeriodMicros(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int maxBackgroundCompactions() {
        assert (this.isOwningHandle());
        return this.maxBackgroundCompactions(this.nativeHandle_);
    }

    @Override
    public Options createStatistics() {
        assert (this.isOwningHandle());
        this.createStatistics(this.nativeHandle_);
        return this;
    }

    @Override
    public Statistics statisticsPtr() {
        assert (this.isOwningHandle());
        long l = this.statisticsPtr(this.nativeHandle_);
        if (l == 0L) {
            this.createStatistics();
            l = this.statisticsPtr(this.nativeHandle_);
        }
        return new Statistics(l);
    }

    @Override
    public void setBaseBackgroundCompactions(int n) {
        assert (this.isOwningHandle());
        this.setBaseBackgroundCompactions(this.nativeHandle_, n);
    }

    @Override
    public int baseBackgroundCompactions() {
        assert (this.isOwningHandle());
        return this.baseBackgroundCompactions(this.nativeHandle_);
    }

    @Override
    public Options setMaxBackgroundCompactions(int n) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundCompactions(this.nativeHandle_, n);
        return this;
    }

    @Override
    public void setMaxSubcompactions(int n) {
        assert (this.isOwningHandle());
        this.setMaxSubcompactions(this.nativeHandle_, n);
    }

    @Override
    public int maxSubcompactions() {
        assert (this.isOwningHandle());
        return this.maxSubcompactions(this.nativeHandle_);
    }

    @Override
    public int maxBackgroundFlushes() {
        assert (this.isOwningHandle());
        return this.maxBackgroundFlushes(this.nativeHandle_);
    }

    @Override
    public Options setMaxBackgroundFlushes(int n) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundFlushes(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long maxLogFileSize() {
        assert (this.isOwningHandle());
        return this.maxLogFileSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxLogFileSize(long l) {
        assert (this.isOwningHandle());
        this.setMaxLogFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long logFileTimeToRoll() {
        assert (this.isOwningHandle());
        return this.logFileTimeToRoll(this.nativeHandle_);
    }

    @Override
    public Options setLogFileTimeToRoll(long l) {
        assert (this.isOwningHandle());
        this.setLogFileTimeToRoll(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long keepLogFileNum() {
        assert (this.isOwningHandle());
        return this.keepLogFileNum(this.nativeHandle_);
    }

    @Override
    public Options setKeepLogFileNum(long l) {
        assert (this.isOwningHandle());
        this.setKeepLogFileNum(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options setRecycleLogFileNum(long l) {
        assert (this.isOwningHandle());
        this.setRecycleLogFileNum(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long recycleLogFileNum() {
        assert (this.isOwningHandle());
        return this.recycleLogFileNum(this.nativeHandle_);
    }

    @Override
    public long maxManifestFileSize() {
        assert (this.isOwningHandle());
        return this.maxManifestFileSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxManifestFileSize(long l) {
        assert (this.isOwningHandle());
        this.setMaxManifestFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options setMaxTableFilesSizeFIFO(long l) {
        assert (l > 0L);
        assert (this.isOwningHandle());
        this.setMaxTableFilesSizeFIFO(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxTableFilesSizeFIFO() {
        return this.maxTableFilesSizeFIFO(this.nativeHandle_);
    }

    @Override
    public int tableCacheNumshardbits() {
        assert (this.isOwningHandle());
        return this.tableCacheNumshardbits(this.nativeHandle_);
    }

    @Override
    public Options setTableCacheNumshardbits(int n) {
        assert (this.isOwningHandle());
        this.setTableCacheNumshardbits(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long walTtlSeconds() {
        assert (this.isOwningHandle());
        return this.walTtlSeconds(this.nativeHandle_);
    }

    @Override
    public Options setWalTtlSeconds(long l) {
        assert (this.isOwningHandle());
        this.setWalTtlSeconds(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walSizeLimitMB() {
        assert (this.isOwningHandle());
        return this.walSizeLimitMB(this.nativeHandle_);
    }

    @Override
    public Options setWalSizeLimitMB(long l) {
        assert (this.isOwningHandle());
        this.setWalSizeLimitMB(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long manifestPreallocationSize() {
        assert (this.isOwningHandle());
        return this.manifestPreallocationSize(this.nativeHandle_);
    }

    @Override
    public Options setManifestPreallocationSize(long l) {
        assert (this.isOwningHandle());
        this.setManifestPreallocationSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options setUseDirectReads(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseDirectReads(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useDirectReads() {
        assert (this.isOwningHandle());
        return this.useDirectReads(this.nativeHandle_);
    }

    @Override
    public Options setUseDirectIoForFlushAndCompaction(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseDirectIoForFlushAndCompaction(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useDirectIoForFlushAndCompaction() {
        assert (this.isOwningHandle());
        return this.useDirectIoForFlushAndCompaction(this.nativeHandle_);
    }

    @Override
    public Options setAllowFAllocate(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllowFAllocate(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowFAllocate() {
        assert (this.isOwningHandle());
        return this.allowFAllocate(this.nativeHandle_);
    }

    @Override
    public boolean allowMmapReads() {
        assert (this.isOwningHandle());
        return this.allowMmapReads(this.nativeHandle_);
    }

    @Override
    public Options setAllowMmapReads(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllowMmapReads(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowMmapWrites() {
        assert (this.isOwningHandle());
        return this.allowMmapWrites(this.nativeHandle_);
    }

    @Override
    public Options setAllowMmapWrites(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllowMmapWrites(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean isFdCloseOnExec() {
        assert (this.isOwningHandle());
        return this.isFdCloseOnExec(this.nativeHandle_);
    }

    @Override
    public Options setIsFdCloseOnExec(boolean bl) {
        assert (this.isOwningHandle());
        this.setIsFdCloseOnExec(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public int statsDumpPeriodSec() {
        assert (this.isOwningHandle());
        return this.statsDumpPeriodSec(this.nativeHandle_);
    }

    @Override
    public Options setStatsDumpPeriodSec(int n) {
        assert (this.isOwningHandle());
        this.setStatsDumpPeriodSec(this.nativeHandle_, n);
        return this;
    }

    @Override
    public boolean adviseRandomOnOpen() {
        return this.adviseRandomOnOpen(this.nativeHandle_);
    }

    @Override
    public Options setAdviseRandomOnOpen(boolean bl) {
        assert (this.isOwningHandle());
        this.setAdviseRandomOnOpen(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public Options setDbWriteBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setDbWriteBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long dbWriteBufferSize() {
        assert (this.isOwningHandle());
        return this.dbWriteBufferSize(this.nativeHandle_);
    }

    @Override
    public Options setAccessHintOnCompactionStart(AccessHint accessHint) {
        assert (this.isOwningHandle());
        this.setAccessHintOnCompactionStart(this.nativeHandle_, accessHint.getValue());
        return this;
    }

    @Override
    public AccessHint accessHintOnCompactionStart() {
        assert (this.isOwningHandle());
        return AccessHint.getAccessHint(this.accessHintOnCompactionStart(this.nativeHandle_));
    }

    @Override
    public Options setNewTableReaderForCompactionInputs(boolean bl) {
        assert (this.isOwningHandle());
        this.setNewTableReaderForCompactionInputs(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean newTableReaderForCompactionInputs() {
        assert (this.isOwningHandle());
        return this.newTableReaderForCompactionInputs(this.nativeHandle_);
    }

    @Override
    public Options setCompactionReadaheadSize(long l) {
        assert (this.isOwningHandle());
        this.setCompactionReadaheadSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long compactionReadaheadSize() {
        assert (this.isOwningHandle());
        return this.compactionReadaheadSize(this.nativeHandle_);
    }

    @Override
    public Options setRandomAccessMaxBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setRandomAccessMaxBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long randomAccessMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.randomAccessMaxBufferSize(this.nativeHandle_);
    }

    @Override
    public Options setWritableFileMaxBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setWritableFileMaxBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writableFileMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.writableFileMaxBufferSize(this.nativeHandle_);
    }

    @Override
    public boolean useAdaptiveMutex() {
        assert (this.isOwningHandle());
        return this.useAdaptiveMutex(this.nativeHandle_);
    }

    @Override
    public Options setUseAdaptiveMutex(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseAdaptiveMutex(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public long bytesPerSync() {
        return this.bytesPerSync(this.nativeHandle_);
    }

    @Override
    public Options setBytesPerSync(long l) {
        assert (this.isOwningHandle());
        this.setBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    @Override
    public Options setWalBytesPerSync(long l) {
        assert (this.isOwningHandle());
        this.setWalBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walBytesPerSync() {
        assert (this.isOwningHandle());
        return this.walBytesPerSync(this.nativeHandle_);
    }

    @Override
    public Options setEnableThreadTracking(boolean bl) {
        assert (this.isOwningHandle());
        this.setEnableThreadTracking(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean enableThreadTracking() {
        assert (this.isOwningHandle());
        return this.enableThreadTracking(this.nativeHandle_);
    }

    @Override
    public Options setDelayedWriteRate(long l) {
        assert (this.isOwningHandle());
        this.setDelayedWriteRate(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long delayedWriteRate() {
        return this.delayedWriteRate(this.nativeHandle_);
    }

    @Override
    public Options setAllowConcurrentMemtableWrite(boolean bl) {
        this.setAllowConcurrentMemtableWrite(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowConcurrentMemtableWrite() {
        return this.allowConcurrentMemtableWrite(this.nativeHandle_);
    }

    @Override
    public Options setEnableWriteThreadAdaptiveYield(boolean bl) {
        this.setEnableWriteThreadAdaptiveYield(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean enableWriteThreadAdaptiveYield() {
        return this.enableWriteThreadAdaptiveYield(this.nativeHandle_);
    }

    @Override
    public Options setWriteThreadMaxYieldUsec(long l) {
        this.setWriteThreadMaxYieldUsec(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeThreadMaxYieldUsec() {
        return this.writeThreadMaxYieldUsec(this.nativeHandle_);
    }

    @Override
    public Options setWriteThreadSlowYieldUsec(long l) {
        this.setWriteThreadSlowYieldUsec(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeThreadSlowYieldUsec() {
        return this.writeThreadSlowYieldUsec(this.nativeHandle_);
    }

    @Override
    public Options setSkipStatsUpdateOnDbOpen(boolean bl) {
        assert (this.isOwningHandle());
        this.setSkipStatsUpdateOnDbOpen(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean skipStatsUpdateOnDbOpen() {
        assert (this.isOwningHandle());
        return this.skipStatsUpdateOnDbOpen(this.nativeHandle_);
    }

    @Override
    public Options setWalRecoveryMode(WALRecoveryMode wALRecoveryMode) {
        assert (this.isOwningHandle());
        this.setWalRecoveryMode(this.nativeHandle_, wALRecoveryMode.getValue());
        return this;
    }

    @Override
    public WALRecoveryMode walRecoveryMode() {
        assert (this.isOwningHandle());
        return WALRecoveryMode.getWALRecoveryMode(this.walRecoveryMode(this.nativeHandle_));
    }

    @Override
    public Options setAllow2pc(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllow2pc(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allow2pc() {
        assert (this.isOwningHandle());
        return this.allow2pc(this.nativeHandle_);
    }

    @Override
    public Options setRowCache(Cache cache) {
        assert (this.isOwningHandle());
        this.setRowCache(this.nativeHandle_, cache.nativeHandle_);
        this.rowCache_ = cache;
        return this;
    }

    @Override
    public Cache rowCache() {
        assert (this.isOwningHandle());
        return this.rowCache_;
    }

    @Override
    public Options setFailIfOptionsFileError(boolean bl) {
        assert (this.isOwningHandle());
        this.setFailIfOptionsFileError(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean failIfOptionsFileError() {
        assert (this.isOwningHandle());
        return this.failIfOptionsFileError(this.nativeHandle_);
    }

    @Override
    public Options setDumpMallocStats(boolean bl) {
        assert (this.isOwningHandle());
        this.setDumpMallocStats(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean dumpMallocStats() {
        assert (this.isOwningHandle());
        return this.dumpMallocStats(this.nativeHandle_);
    }

    @Override
    public Options setAvoidFlushDuringRecovery(boolean bl) {
        assert (this.isOwningHandle());
        this.setAvoidFlushDuringRecovery(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean avoidFlushDuringRecovery() {
        assert (this.isOwningHandle());
        return this.avoidFlushDuringRecovery(this.nativeHandle_);
    }

    @Override
    public Options setAvoidFlushDuringShutdown(boolean bl) {
        assert (this.isOwningHandle());
        this.setAvoidFlushDuringShutdown(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean avoidFlushDuringShutdown() {
        assert (this.isOwningHandle());
        return this.avoidFlushDuringShutdown(this.nativeHandle_);
    }

    @Override
    public MemTableConfig memTableConfig() {
        return this.memTableConfig_;
    }

    @Override
    public Options setMemTableConfig(MemTableConfig memTableConfig) {
        this.memTableConfig_ = memTableConfig;
        this.setMemTableFactory(this.nativeHandle_, memTableConfig.newMemTableFactoryHandle());
        return this;
    }

    @Override
    public Options setRateLimiter(RateLimiter rateLimiter) {
        assert (this.isOwningHandle());
        this.rateLimiter_ = rateLimiter;
        this.setRateLimiter(this.nativeHandle_, rateLimiter.nativeHandle_);
        return this;
    }

    @Override
    public Options setLogger(Logger logger2) {
        assert (this.isOwningHandle());
        this.setLogger(this.nativeHandle_, logger2.nativeHandle_);
        return this;
    }

    @Override
    public Options setInfoLogLevel(InfoLogLevel infoLogLevel) {
        assert (this.isOwningHandle());
        this.setInfoLogLevel(this.nativeHandle_, infoLogLevel.getValue());
        return this;
    }

    @Override
    public InfoLogLevel infoLogLevel() {
        assert (this.isOwningHandle());
        return InfoLogLevel.getInfoLogLevel(this.infoLogLevel(this.nativeHandle_));
    }

    @Override
    public String memTableFactoryName() {
        assert (this.isOwningHandle());
        return this.memTableFactoryName(this.nativeHandle_);
    }

    @Override
    public TableFormatConfig tableFormatConfig() {
        return this.tableFormatConfig_;
    }

    @Override
    public Options setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        this.tableFormatConfig_ = tableFormatConfig;
        this.setTableFactory(this.nativeHandle_, tableFormatConfig.newTableFactoryHandle());
        return this;
    }

    @Override
    public String tableFactoryName() {
        assert (this.isOwningHandle());
        return this.tableFactoryName(this.nativeHandle_);
    }

    @Override
    public Options useFixedLengthPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useFixedLengthPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options useCappedPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useCappedPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public CompressionType compressionType() {
        return CompressionType.getCompressionType(this.compressionType(this.nativeHandle_));
    }

    @Override
    public Options setCompressionPerLevel(List<CompressionType> list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            byArray[i] = list.get(i).getValue();
        }
        this.setCompressionPerLevel(this.nativeHandle_, byArray);
        return this;
    }

    @Override
    public List<CompressionType> compressionPerLevel() {
        byte[] byArray = this.compressionPerLevel(this.nativeHandle_);
        ArrayList<CompressionType> arrayList = new ArrayList<CompressionType>();
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            Byte by = byArray2[i];
            arrayList.add(CompressionType.getCompressionType(by));
        }
        return arrayList;
    }

    @Override
    public Options setCompressionType(CompressionType compressionType) {
        this.setCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public Options setBottommostCompressionType(CompressionType compressionType) {
        this.setBottommostCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompressionType bottommostCompressionType() {
        return CompressionType.getCompressionType(this.bottommostCompressionType(this.nativeHandle_));
    }

    @Override
    public Options setCompressionOptions(CompressionOptions compressionOptions) {
        this.setCompressionOptions(this.nativeHandle_, compressionOptions.nativeHandle_);
        this.compressionOptions_ = compressionOptions;
        return this;
    }

    @Override
    public CompressionOptions compressionOptions() {
        return this.compressionOptions_;
    }

    @Override
    public CompactionStyle compactionStyle() {
        return CompactionStyle.values()[this.compactionStyle(this.nativeHandle_)];
    }

    @Override
    public Options setCompactionStyle(CompactionStyle compactionStyle) {
        this.setCompactionStyle(this.nativeHandle_, compactionStyle.getValue());
        return this;
    }

    @Override
    public int numLevels() {
        return this.numLevels(this.nativeHandle_);
    }

    @Override
    public Options setNumLevels(int n) {
        this.setNumLevels(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroFileNumCompactionTrigger() {
        return this.levelZeroFileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroFileNumCompactionTrigger(int n) {
        this.setLevelZeroFileNumCompactionTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroSlowdownWritesTrigger() {
        return this.levelZeroSlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroSlowdownWritesTrigger(int n) {
        this.setLevelZeroSlowdownWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int levelZeroStopWritesTrigger() {
        return this.levelZeroStopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroStopWritesTrigger(int n) {
        this.setLevelZeroStopWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long targetFileSizeBase() {
        return this.targetFileSizeBase(this.nativeHandle_);
    }

    @Override
    public Options setTargetFileSizeBase(long l) {
        this.setTargetFileSizeBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int targetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier(this.nativeHandle_);
    }

    @Override
    public Options setTargetFileSizeMultiplier(int n) {
        this.setTargetFileSizeMultiplier(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options setMaxBytesForLevelBase(long l) {
        this.setMaxBytesForLevelBase(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxBytesForLevelBase() {
        return this.maxBytesForLevelBase(this.nativeHandle_);
    }

    @Override
    public Options setLevelCompactionDynamicLevelBytes(boolean bl) {
        this.setLevelCompactionDynamicLevelBytes(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean levelCompactionDynamicLevelBytes() {
        return this.levelCompactionDynamicLevelBytes(this.nativeHandle_);
    }

    @Override
    public double maxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier(this.nativeHandle_);
    }

    @Override
    public Options setMaxBytesForLevelMultiplier(double d) {
        this.setMaxBytesForLevelMultiplier(this.nativeHandle_, d);
        return this;
    }

    @Override
    public long maxCompactionBytes() {
        return this.maxCompactionBytes(this.nativeHandle_);
    }

    @Override
    public Options setMaxCompactionBytes(long l) {
        this.setMaxCompactionBytes(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long arenaBlockSize() {
        return this.arenaBlockSize(this.nativeHandle_);
    }

    @Override
    public Options setArenaBlockSize(long l) {
        this.setArenaBlockSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public boolean disableAutoCompactions() {
        return this.disableAutoCompactions(this.nativeHandle_);
    }

    @Override
    public Options setDisableAutoCompactions(boolean bl) {
        this.setDisableAutoCompactions(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public long maxSequentialSkipInIterations() {
        return this.maxSequentialSkipInIterations(this.nativeHandle_);
    }

    @Override
    public Options setMaxSequentialSkipInIterations(long l) {
        this.setMaxSequentialSkipInIterations(this.nativeHandle_, l);
        return this;
    }

    @Override
    public boolean inplaceUpdateSupport() {
        return this.inplaceUpdateSupport(this.nativeHandle_);
    }

    @Override
    public Options setInplaceUpdateSupport(boolean bl) {
        this.setInplaceUpdateSupport(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public long inplaceUpdateNumLocks() {
        return this.inplaceUpdateNumLocks(this.nativeHandle_);
    }

    @Override
    public Options setInplaceUpdateNumLocks(long l) {
        this.setInplaceUpdateNumLocks(this.nativeHandle_, l);
        return this;
    }

    @Override
    public double memtablePrefixBloomSizeRatio() {
        return this.memtablePrefixBloomSizeRatio(this.nativeHandle_);
    }

    @Override
    public Options setMemtablePrefixBloomSizeRatio(double d) {
        this.setMemtablePrefixBloomSizeRatio(this.nativeHandle_, d);
        return this;
    }

    @Override
    public int bloomLocality() {
        return this.bloomLocality(this.nativeHandle_);
    }

    @Override
    public Options setBloomLocality(int n) {
        this.setBloomLocality(this.nativeHandle_, n);
        return this;
    }

    @Override
    public long maxSuccessiveMerges() {
        return this.maxSuccessiveMerges(this.nativeHandle_);
    }

    @Override
    public Options setMaxSuccessiveMerges(long l) {
        this.setMaxSuccessiveMerges(this.nativeHandle_, l);
        return this;
    }

    @Override
    public int minWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge(this.nativeHandle_);
    }

    @Override
    public Options setMinWriteBufferNumberToMerge(int n) {
        this.setMinWriteBufferNumberToMerge(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options setOptimizeFiltersForHits(boolean bl) {
        this.setOptimizeFiltersForHits(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean optimizeFiltersForHits() {
        return this.optimizeFiltersForHits(this.nativeHandle_);
    }

    @Override
    public Options setMemtableHugePageSize(long l) {
        this.setMemtableHugePageSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long memtableHugePageSize() {
        return this.memtableHugePageSize(this.nativeHandle_);
    }

    @Override
    public Options setSoftPendingCompactionBytesLimit(long l) {
        this.setSoftPendingCompactionBytesLimit(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long softPendingCompactionBytesLimit() {
        return this.softPendingCompactionBytesLimit(this.nativeHandle_);
    }

    @Override
    public Options setHardPendingCompactionBytesLimit(long l) {
        this.setHardPendingCompactionBytesLimit(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long hardPendingCompactionBytesLimit() {
        return this.hardPendingCompactionBytesLimit(this.nativeHandle_);
    }

    @Override
    public Options setLevel0FileNumCompactionTrigger(int n) {
        this.setLevel0FileNumCompactionTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int level0FileNumCompactionTrigger() {
        return this.level0FileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevel0SlowdownWritesTrigger(int n) {
        this.setLevel0SlowdownWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int level0SlowdownWritesTrigger() {
        return this.level0SlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevel0StopWritesTrigger(int n) {
        this.setLevel0StopWritesTrigger(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int level0StopWritesTrigger() {
        return this.level0StopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setMaxBytesForLevelMultiplierAdditional(int[] nArray) {
        this.setMaxBytesForLevelMultiplierAdditional(this.nativeHandle_, nArray);
        return this;
    }

    @Override
    public int[] maxBytesForLevelMultiplierAdditional() {
        return this.maxBytesForLevelMultiplierAdditional(this.nativeHandle_);
    }

    @Override
    public Options setParanoidFileChecks(boolean bl) {
        this.setParanoidFileChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean paranoidFileChecks() {
        return this.paranoidFileChecks(this.nativeHandle_);
    }

    @Override
    public Options setMaxWriteBufferNumberToMaintain(int n) {
        this.setMaxWriteBufferNumberToMaintain(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxWriteBufferNumberToMaintain() {
        return this.maxWriteBufferNumberToMaintain(this.nativeHandle_);
    }

    @Override
    public Options setCompactionPriority(CompactionPriority compactionPriority) {
        this.setCompactionPriority(this.nativeHandle_, compactionPriority.getValue());
        return this;
    }

    @Override
    public CompactionPriority compactionPriority() {
        return CompactionPriority.getCompactionPriority(this.compactionPriority(this.nativeHandle_));
    }

    @Override
    public Options setReportBgIoStats(boolean bl) {
        this.setReportBgIoStats(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean reportBgIoStats() {
        return this.reportBgIoStats(this.nativeHandle_);
    }

    @Override
    public Options setCompactionOptionsUniversal(CompactionOptionsUniversal compactionOptionsUniversal) {
        this.setCompactionOptionsUniversal(this.nativeHandle_, compactionOptionsUniversal.nativeHandle_);
        this.compactionOptionsUniversal_ = compactionOptionsUniversal;
        return this;
    }

    @Override
    public CompactionOptionsUniversal compactionOptionsUniversal() {
        return this.compactionOptionsUniversal_;
    }

    @Override
    public Options setCompactionOptionsFIFO(CompactionOptionsFIFO compactionOptionsFIFO) {
        this.setCompactionOptionsFIFO(this.nativeHandle_, compactionOptionsFIFO.nativeHandle_);
        this.compactionOptionsFIFO_ = compactionOptionsFIFO;
        return this;
    }

    @Override
    public CompactionOptionsFIFO compactionOptionsFIFO() {
        return this.compactionOptionsFIFO_;
    }

    @Override
    public Options setForceConsistencyChecks(boolean bl) {
        this.setForceConsistencyChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean forceConsistencyChecks() {
        return this.forceConsistencyChecks(this.nativeHandle_);
    }

    private static native long newOptions();

    private static native long newOptions(long var0, long var2);

    @Override
    protected final native void disposeInternal(long var1);

    private native void setEnv(long var1, long var3);

    private native void prepareForBulkLoad(long var1);

    private native void setIncreaseParallelism(long var1, int var3);

    private native void setCreateIfMissing(long var1, boolean var3);

    private native boolean createIfMissing(long var1);

    private native void setCreateMissingColumnFamilies(long var1, boolean var3);

    private native boolean createMissingColumnFamilies(long var1);

    private native void setErrorIfExists(long var1, boolean var3);

    private native boolean errorIfExists(long var1);

    private native void setParanoidChecks(long var1, boolean var3);

    private native boolean paranoidChecks(long var1);

    private native void setRateLimiter(long var1, long var3);

    private native void setLogger(long var1, long var3);

    private native void setInfoLogLevel(long var1, byte var3);

    private native byte infoLogLevel(long var1);

    private native void setMaxOpenFiles(long var1, int var3);

    private native int maxOpenFiles(long var1);

    private native void setMaxTotalWalSize(long var1, long var3);

    private native void setMaxFileOpeningThreads(long var1, int var3);

    private native int maxFileOpeningThreads(long var1);

    private native long maxTotalWalSize(long var1);

    private native void createStatistics(long var1);

    private native long statisticsPtr(long var1);

    private native boolean useFsync(long var1);

    private native void setUseFsync(long var1, boolean var3);

    private native void setDbPaths(long var1, String[] var3, long[] var4);

    private native long dbPathsLen(long var1);

    private native void dbPaths(long var1, String[] var3, long[] var4);

    private native void setDbLogDir(long var1, String var3);

    private native String dbLogDir(long var1);

    private native void setWalDir(long var1, String var3);

    private native String walDir(long var1);

    private native void setDeleteObsoleteFilesPeriodMicros(long var1, long var3);

    private native long deleteObsoleteFilesPeriodMicros(long var1);

    private native void setBaseBackgroundCompactions(long var1, int var3);

    private native int baseBackgroundCompactions(long var1);

    private native void setMaxBackgroundCompactions(long var1, int var3);

    private native int maxBackgroundCompactions(long var1);

    private native void setMaxSubcompactions(long var1, int var3);

    private native int maxSubcompactions(long var1);

    private native void setMaxBackgroundFlushes(long var1, int var3);

    private native int maxBackgroundFlushes(long var1);

    private native void setMaxLogFileSize(long var1, long var3) throws IllegalArgumentException;

    private native long maxLogFileSize(long var1);

    private native void setLogFileTimeToRoll(long var1, long var3) throws IllegalArgumentException;

    private native long logFileTimeToRoll(long var1);

    private native void setKeepLogFileNum(long var1, long var3) throws IllegalArgumentException;

    private native long keepLogFileNum(long var1);

    private native void setRecycleLogFileNum(long var1, long var3);

    private native long recycleLogFileNum(long var1);

    private native void setMaxManifestFileSize(long var1, long var3);

    private native long maxManifestFileSize(long var1);

    private native void setMaxTableFilesSizeFIFO(long var1, long var3);

    private native long maxTableFilesSizeFIFO(long var1);

    private native void setTableCacheNumshardbits(long var1, int var3);

    private native int tableCacheNumshardbits(long var1);

    private native void setWalTtlSeconds(long var1, long var3);

    private native long walTtlSeconds(long var1);

    private native void setWalSizeLimitMB(long var1, long var3);

    private native long walSizeLimitMB(long var1);

    private native void setManifestPreallocationSize(long var1, long var3) throws IllegalArgumentException;

    private native long manifestPreallocationSize(long var1);

    private native void setUseDirectReads(long var1, boolean var3);

    private native boolean useDirectReads(long var1);

    private native void setUseDirectIoForFlushAndCompaction(long var1, boolean var3);

    private native boolean useDirectIoForFlushAndCompaction(long var1);

    private native void setAllowFAllocate(long var1, boolean var3);

    private native boolean allowFAllocate(long var1);

    private native void setAllowMmapReads(long var1, boolean var3);

    private native boolean allowMmapReads(long var1);

    private native void setAllowMmapWrites(long var1, boolean var3);

    private native boolean allowMmapWrites(long var1);

    private native void setIsFdCloseOnExec(long var1, boolean var3);

    private native boolean isFdCloseOnExec(long var1);

    private native void setStatsDumpPeriodSec(long var1, int var3);

    private native int statsDumpPeriodSec(long var1);

    private native void setAdviseRandomOnOpen(long var1, boolean var3);

    private native boolean adviseRandomOnOpen(long var1);

    private native void setDbWriteBufferSize(long var1, long var3);

    private native long dbWriteBufferSize(long var1);

    private native void setAccessHintOnCompactionStart(long var1, byte var3);

    private native byte accessHintOnCompactionStart(long var1);

    private native void setNewTableReaderForCompactionInputs(long var1, boolean var3);

    private native boolean newTableReaderForCompactionInputs(long var1);

    private native void setCompactionReadaheadSize(long var1, long var3);

    private native long compactionReadaheadSize(long var1);

    private native void setRandomAccessMaxBufferSize(long var1, long var3);

    private native long randomAccessMaxBufferSize(long var1);

    private native void setWritableFileMaxBufferSize(long var1, long var3);

    private native long writableFileMaxBufferSize(long var1);

    private native void setUseAdaptiveMutex(long var1, boolean var3);

    private native boolean useAdaptiveMutex(long var1);

    private native void setBytesPerSync(long var1, long var3);

    private native long bytesPerSync(long var1);

    private native void setWalBytesPerSync(long var1, long var3);

    private native long walBytesPerSync(long var1);

    private native void setEnableThreadTracking(long var1, boolean var3);

    private native boolean enableThreadTracking(long var1);

    private native void setDelayedWriteRate(long var1, long var3);

    private native long delayedWriteRate(long var1);

    private native void setAllowConcurrentMemtableWrite(long var1, boolean var3);

    private native boolean allowConcurrentMemtableWrite(long var1);

    private native void setEnableWriteThreadAdaptiveYield(long var1, boolean var3);

    private native boolean enableWriteThreadAdaptiveYield(long var1);

    private native void setWriteThreadMaxYieldUsec(long var1, long var3);

    private native long writeThreadMaxYieldUsec(long var1);

    private native void setWriteThreadSlowYieldUsec(long var1, long var3);

    private native long writeThreadSlowYieldUsec(long var1);

    private native void setSkipStatsUpdateOnDbOpen(long var1, boolean var3);

    private native boolean skipStatsUpdateOnDbOpen(long var1);

    private native void setWalRecoveryMode(long var1, byte var3);

    private native byte walRecoveryMode(long var1);

    private native void setAllow2pc(long var1, boolean var3);

    private native boolean allow2pc(long var1);

    private native void setRowCache(long var1, long var3);

    private native void setFailIfOptionsFileError(long var1, boolean var3);

    private native boolean failIfOptionsFileError(long var1);

    private native void setDumpMallocStats(long var1, boolean var3);

    private native boolean dumpMallocStats(long var1);

    private native void setAvoidFlushDuringRecovery(long var1, boolean var3);

    private native boolean avoidFlushDuringRecovery(long var1);

    private native void setAvoidFlushDuringShutdown(long var1, boolean var3);

    private native boolean avoidFlushDuringShutdown(long var1);

    private native void optimizeForSmallDb(long var1);

    private native void optimizeForPointLookup(long var1, long var3);

    private native void optimizeLevelStyleCompaction(long var1, long var3);

    private native void optimizeUniversalStyleCompaction(long var1, long var3);

    private native void setComparatorHandle(long var1, int var3);

    private native void setComparatorHandle(long var1, long var3);

    private native void setMergeOperatorName(long var1, String var3);

    private native void setMergeOperator(long var1, long var3);

    private native void setWriteBufferSize(long var1, long var3) throws IllegalArgumentException;

    private native long writeBufferSize(long var1);

    private native void setMaxWriteBufferNumber(long var1, int var3);

    private native int maxWriteBufferNumber(long var1);

    private native void setMinWriteBufferNumberToMerge(long var1, int var3);

    private native int minWriteBufferNumberToMerge(long var1);

    private native void setCompressionType(long var1, byte var3);

    private native byte compressionType(long var1);

    private native void setCompressionPerLevel(long var1, byte[] var3);

    private native byte[] compressionPerLevel(long var1);

    private native void setBottommostCompressionType(long var1, byte var3);

    private native byte bottommostCompressionType(long var1);

    private native void setCompressionOptions(long var1, long var3);

    private native void useFixedLengthPrefixExtractor(long var1, int var3);

    private native void useCappedPrefixExtractor(long var1, int var3);

    private native void setNumLevels(long var1, int var3);

    private native int numLevels(long var1);

    private native void setLevelZeroFileNumCompactionTrigger(long var1, int var3);

    private native int levelZeroFileNumCompactionTrigger(long var1);

    private native void setLevelZeroSlowdownWritesTrigger(long var1, int var3);

    private native int levelZeroSlowdownWritesTrigger(long var1);

    private native void setLevelZeroStopWritesTrigger(long var1, int var3);

    private native int levelZeroStopWritesTrigger(long var1);

    private native void setTargetFileSizeBase(long var1, long var3);

    private native long targetFileSizeBase(long var1);

    private native void setTargetFileSizeMultiplier(long var1, int var3);

    private native int targetFileSizeMultiplier(long var1);

    private native void setMaxBytesForLevelBase(long var1, long var3);

    private native long maxBytesForLevelBase(long var1);

    private native void setLevelCompactionDynamicLevelBytes(long var1, boolean var3);

    private native boolean levelCompactionDynamicLevelBytes(long var1);

    private native void setMaxBytesForLevelMultiplier(long var1, double var3);

    private native double maxBytesForLevelMultiplier(long var1);

    private native void setMaxCompactionBytes(long var1, long var3);

    private native long maxCompactionBytes(long var1);

    private native void setArenaBlockSize(long var1, long var3) throws IllegalArgumentException;

    private native long arenaBlockSize(long var1);

    private native void setDisableAutoCompactions(long var1, boolean var3);

    private native boolean disableAutoCompactions(long var1);

    private native void setCompactionStyle(long var1, byte var3);

    private native byte compactionStyle(long var1);

    private native void setMaxSequentialSkipInIterations(long var1, long var3);

    private native long maxSequentialSkipInIterations(long var1);

    private native void setMemTableFactory(long var1, long var3);

    private native String memTableFactoryName(long var1);

    private native void setTableFactory(long var1, long var3);

    private native String tableFactoryName(long var1);

    private native void setInplaceUpdateSupport(long var1, boolean var3);

    private native boolean inplaceUpdateSupport(long var1);

    private native void setInplaceUpdateNumLocks(long var1, long var3) throws IllegalArgumentException;

    private native long inplaceUpdateNumLocks(long var1);

    private native void setMemtablePrefixBloomSizeRatio(long var1, double var3);

    private native double memtablePrefixBloomSizeRatio(long var1);

    private native void setBloomLocality(long var1, int var3);

    private native int bloomLocality(long var1);

    private native void setMaxSuccessiveMerges(long var1, long var3) throws IllegalArgumentException;

    private native long maxSuccessiveMerges(long var1);

    private native void setOptimizeFiltersForHits(long var1, boolean var3);

    private native boolean optimizeFiltersForHits(long var1);

    private native void setMemtableHugePageSize(long var1, long var3);

    private native long memtableHugePageSize(long var1);

    private native void setSoftPendingCompactionBytesLimit(long var1, long var3);

    private native long softPendingCompactionBytesLimit(long var1);

    private native void setHardPendingCompactionBytesLimit(long var1, long var3);

    private native long hardPendingCompactionBytesLimit(long var1);

    private native void setLevel0FileNumCompactionTrigger(long var1, int var3);

    private native int level0FileNumCompactionTrigger(long var1);

    private native void setLevel0SlowdownWritesTrigger(long var1, int var3);

    private native int level0SlowdownWritesTrigger(long var1);

    private native void setLevel0StopWritesTrigger(long var1, int var3);

    private native int level0StopWritesTrigger(long var1);

    private native void setMaxBytesForLevelMultiplierAdditional(long var1, int[] var3);

    private native int[] maxBytesForLevelMultiplierAdditional(long var1);

    private native void setParanoidFileChecks(long var1, boolean var3);

    private native boolean paranoidFileChecks(long var1);

    private native void setMaxWriteBufferNumberToMaintain(long var1, int var3);

    private native int maxWriteBufferNumberToMaintain(long var1);

    private native void setCompactionPriority(long var1, byte var3);

    private native byte compactionPriority(long var1);

    private native void setReportBgIoStats(long var1, boolean var3);

    private native boolean reportBgIoStats(long var1);

    private native void setCompactionOptionsUniversal(long var1, long var3);

    private native void setCompactionOptionsFIFO(long var1, long var3);

    private native void setForceConsistencyChecks(long var1, boolean var3);

    private native boolean forceConsistencyChecks(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

