/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.ByRef;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.locks.DeadlockChecker;
import org.infinispan.util.concurrent.locks.ExtendedLockPromise;
import org.infinispan.util.concurrent.locks.impl.InfinispanLock;
import org.infinispan.util.concurrent.locks.impl.LockContainer;

public class PerKeyLockContainer
implements LockContainer {
    private static final int INITIAL_CAPACITY = 32;
    private final ConcurrentMap<Object, InfinispanLock> lockMap = new ConcurrentHashMap<Object, InfinispanLock>(32);
    private TimeService timeService;

    @Inject
    public void inject(TimeService timeService) {
        this.timeService = timeService;
        for (InfinispanLock lock : this.lockMap.values()) {
            lock.setTimeService(timeService);
        }
    }

    @Override
    public ExtendedLockPromise acquire(Object key, Object lockOwner, long time, TimeUnit timeUnit) {
        ByRef<Object> reference = ByRef.create(null);
        this.lockMap.compute(key, (aKey, lock) -> {
            if (lock == null) {
                lock = this.createInfinispanLock(aKey);
            }
            reference.set(lock.acquire(lockOwner, time, timeUnit));
            return lock;
        });
        return reference.get();
    }

    @Override
    public InfinispanLock getLock(Object key) {
        return (InfinispanLock)this.lockMap.get(key);
    }

    @Override
    public void release(Object key, Object lockOwner) {
        this.lockMap.computeIfPresent(key, (ignoredKey, lock) -> {
            lock.release(lockOwner);
            return !lock.isLocked() ? null : lock;
        });
    }

    @Override
    public int getNumLocksHeld() {
        int count = 0;
        for (InfinispanLock lock : this.lockMap.values()) {
            if (!lock.isLocked()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isLocked(Object key) {
        InfinispanLock lock = (InfinispanLock)this.lockMap.get(key);
        return lock != null && lock.isLocked();
    }

    @Override
    public int size() {
        return this.lockMap.size();
    }

    @Override
    public void deadlockCheck(DeadlockChecker deadlockChecker) {
        this.lockMap.values().forEach(lock -> lock.deadlockCheck(deadlockChecker));
    }

    public String toString() {
        return "PerKeyLockContainer{locks=" + this.lockMap + '}';
    }

    private InfinispanLock createInfinispanLock(Object key) {
        return new InfinispanLock(this.timeService, () -> this.lockMap.computeIfPresent(key, (ignoredKey, lock) -> lock.isLocked() ? lock : null));
    }
}

