/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class RangeSet
implements Set<Integer> {
    final int size;

    public RangeSet(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size <= 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        int i = (Integer)o;
        return 0 <= i && i < this.size;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new RangeSetIterator(this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] array = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        for (int i = 0; i < this.size; ++i) {
            array[i] = i;
        }
        return array;
    }

    @Override
    public boolean add(Integer integer) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Set)) {
            return false;
        }
        if (o instanceof RangeSet) {
            RangeSet integers = (RangeSet)o;
            return this.size == integers.size;
        }
        Set set = (Set)o;
        return this.size == set.size() && this.containsAll(set);
    }

    @Override
    public int hashCode() {
        return this.size;
    }

    public String toString() {
        return "RangeSet(" + this.size + ")";
    }

    private static class RangeSetIterator
    implements Iterator<Integer> {
        private int size;
        private int next;

        public RangeSetIterator(int size) {
            this.size = size;
            this.next = 0;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.size;
        }

        @Override
        public Integer next() {
            if (this.next >= this.size) {
                throw new NoSuchElementException();
            }
            return this.next++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("RangeSet is read-only");
        }
    }
}

