/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.util.Immutables;
import org.infinispan.remoting.transport.Address;

public class ClusterView {
    static final int INITIAL_VIEW_ID = -1;
    static final int FINAL_VIEW_ID = Integer.MAX_VALUE;
    private final int viewId;
    private final List<Address> members;
    private final Set<Address> membersSet;
    private final Address coordinator;
    private final boolean isCoordinator;

    ClusterView(int viewId, List<Address> members, Address self) {
        this.viewId = viewId;
        this.members = Immutables.immutableListCopy(members);
        this.membersSet = Collections.unmodifiableSet(new HashSet<Address>(members));
        if (!members.isEmpty()) {
            this.coordinator = members.get(0);
            this.isCoordinator = this.coordinator.equals(self);
        } else {
            this.coordinator = null;
            this.isCoordinator = false;
        }
    }

    public int getViewId() {
        return this.viewId;
    }

    public boolean isViewIdAtLeast(int expectedViewId) {
        return expectedViewId <= this.viewId;
    }

    public boolean isStopped() {
        return this.viewId == Integer.MAX_VALUE;
    }

    public List<Address> getMembers() {
        return this.members;
    }

    public Set<Address> getMembersSet() {
        return this.membersSet;
    }

    public Address getCoordinator() {
        return this.coordinator;
    }

    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    public String toString() {
        return this.coordinator + "|" + this.viewId + this.members;
    }
}

