/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.ProtoUnknownFieldSet;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;

final class ProtoMessageTypeMetadata
extends ProtoTypeMetadata {
    private final ProtoSchemaGenerator protoSchemaGenerator;
    private Map<Integer, ProtoFieldMetadata> fields = null;
    private Field unknownFieldSetField;
    private Method unknownFieldSetGetter;
    private Method unknownFieldSetSetter;
    private final Map<Class<?>, ProtoTypeMetadata> innerTypes = new HashMap();

    ProtoMessageTypeMetadata(ProtoSchemaGenerator protoSchemaGenerator, Class<?> messageClass) {
        super(ProtoMessageTypeMetadata.getProtoName(messageClass), messageClass);
        this.protoSchemaGenerator = protoSchemaGenerator;
        if (Modifier.isAbstract(this.javaClass.getModifiers())) {
            throw new ProtoSchemaBuilderException("Abstract classes are not allowed: " + this.javaClass);
        }
        try {
            this.javaClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ProtoSchemaBuilderException("The class " + this.javaClass.getCanonicalName() + " must be instantiable using a public no-argument constructor.");
        }
    }

    private static String getProtoName(Class<?> messageClass) {
        ProtoMessage annotation = messageClass.getAnnotation(ProtoMessage.class);
        return annotation == null || annotation.name().isEmpty() ? messageClass.getSimpleName() : annotation.name();
    }

    public Field getUnknownFieldSetField() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetField;
    }

    public Method getUnknownFieldSetGetter() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetGetter;
    }

    public Method getUnknownFieldSetSetter() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetSetter;
    }

    public Map<Integer, ProtoFieldMetadata> getFields() {
        this.scanMemberAnnotations();
        return this.fields;
    }

    protected void addInnerType(ProtoTypeMetadata typeMetadata) {
        this.innerTypes.put(typeMetadata.getJavaClass(), typeMetadata);
    }

    @Override
    public void generateProto(IndentWriter iw) {
        this.scanMemberAnnotations();
        iw.append("\n\n");
        ProtoMessageTypeMetadata.appendDocumentation(iw, this.documentation);
        iw.append("message ").append(this.name);
        if (ProtoSchemaBuilder.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.javaClass.getCanonicalName()).append(" */");
        }
        iw.append(" {\n");
        if (!this.innerTypes.isEmpty()) {
            iw.inc();
            for (ProtoTypeMetadata t : this.innerTypes.values()) {
                t.generateProto(iw);
            }
            iw.dec();
        }
        iw.inc();
        for (ProtoFieldMetadata f : this.fields.values()) {
            f.generateProto(iw);
        }
        iw.dec();
        iw.append("}\n");
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public void scanMemberAnnotations() {
        if (this.fields == null) {
            this.fields = new TreeMap<Integer, ProtoFieldMetadata>();
            HashMap<String, ProtoFieldMetadata> fieldByName = new HashMap<String, ProtoFieldMetadata>();
            HashSet examinedClasses = new HashSet();
            this.discoverFields(this.javaClass, examinedClasses, this.fields, fieldByName);
            if (this.fields.isEmpty()) {
                throw new ProtoSchemaBuilderException("Class " + this.javaClass.getCanonicalName() + " does not have any @ProtoField annotated fields. The class should be either annotated or it should have a custom marshaller.");
            }
            this.checkConstructor();
        }
    }

    private void checkConstructor() {
        Constructor ctor;
        try {
            ctor = this.javaClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ProtoSchemaBuilderException("Class " + this.javaClass.getCanonicalName() + " must have a non-private no argument constructor");
        }
        if (Modifier.isPrivate(ctor.getModifiers())) {
            throw new ProtoSchemaBuilderException("Class " + this.javaClass.getCanonicalName() + " must have a non-private no argument constructor");
        }
    }

    private void discoverFields(Class<?> clazz, Set<Class<?>> examinedClasses, Map<Integer, ProtoFieldMetadata> fieldsByNumber, Map<String, ProtoFieldMetadata> fieldsByName) {
        ProtoField annotation;
        if (!examinedClasses.add(clazz)) {
            return;
        }
        if (clazz.getSuperclass() != null) {
            this.discoverFields(clazz.getSuperclass(), examinedClasses, fieldsByNumber, fieldsByName);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.discoverFields(clazz2, examinedClasses, fieldsByNumber, fieldsByName);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            if (((Field)annotatedElement).getAnnotation(ProtoUnknownFieldSet.class) != null) {
                if (this.unknownFieldSetField != null || this.unknownFieldSetGetter != null || this.unknownFieldSetSetter != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet annotation should not be used multiple times : " + annotatedElement);
                }
                this.unknownFieldSetField = annotatedElement;
                continue;
            }
            annotation = ((Field)annotatedElement).getAnnotation(ProtoField.class);
            if (annotation == null) continue;
            if (Modifier.isStatic(((Field)annotatedElement).getModifiers())) {
                throw new ProtoSchemaBuilderException("Static fields cannot be @ProtoField annotated: " + annotatedElement);
            }
            if (Modifier.isFinal(((Field)annotatedElement).getModifiers())) {
                throw new ProtoSchemaBuilderException("Final fields cannot be @ProtoField annotated: " + annotatedElement);
            }
            if (Modifier.isPrivate(((Field)annotatedElement).getModifiers())) {
                throw new ProtoSchemaBuilderException("Non-public fields cannot be @ProtoField annotated: " + annotatedElement);
            }
            String fieldName = annotation.name();
            if (fieldName.isEmpty()) {
                fieldName = ((Field)annotatedElement).getName();
            }
            boolean isArray = ((Field)annotatedElement).getType().isArray();
            boolean isRepeated = this.isRepeated(((Field)annotatedElement).getType());
            boolean isRequired = annotation.required();
            if (isRepeated && isRequired) {
                throw new ProtoSchemaBuilderException("Repeated field '" + fieldName + "' of " + clazz + " cannot be marked required.");
            }
            Class<?> javaType = annotation.javaType();
            if (javaType == Void.TYPE) {
                javaType = isRepeated ? ProtoMessageTypeMetadata.determineElementType(((Field)annotatedElement).getType(), ((Field)annotatedElement).getGenericType()) : ((Field)annotatedElement).getType();
            }
            if (!javaType.isArray() && !javaType.isPrimitive() && Modifier.isAbstract(javaType.getModifiers())) {
                throw new ProtoSchemaBuilderException("The class " + javaType.getName() + " of repeated field '" + fieldName + "' of " + clazz + " should not be abstract.");
            }
            Object defaultValue = this.getDefaultValue(clazz, fieldName, javaType, annotation.defaultValue());
            if (!isRequired && !isRepeated && javaType.isPrimitive() && defaultValue == null) {
                throw new ProtoSchemaBuilderException("Primitive field '" + fieldName + "' of " + clazz + " should be marked required or should have a default value.");
            }
            Class<?> collectionImplementation = this.getCollectionImplementation(clazz, ((Field)annotatedElement).getType(), annotation.collectionImplementation(), fieldName, isRepeated);
            org.infinispan.protostream.descriptors.Type protobufType = this.getProtobufType(javaType, annotation.type());
            ProtoTypeMetadata protoTypeMetadata = null;
            if (protobufType == org.infinispan.protostream.descriptors.Type.ENUM || protobufType == org.infinispan.protostream.descriptors.Type.MESSAGE || protobufType == org.infinispan.protostream.descriptors.Type.GROUP) {
                protoTypeMetadata = this.protoSchemaGenerator.scanAnnotations(javaType);
            }
            ProtoFieldMetadata fieldMetadata = new ProtoFieldMetadata(clazz, annotation.number(), fieldName, javaType, collectionImplementation, protobufType, protoTypeMetadata, isRequired, isRepeated, isArray, defaultValue, (Field)annotatedElement);
            ProtoFieldMetadata existing = fieldsByNumber.get(annotation.number());
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with number " + annotation.number() + ": in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            existing = fieldsByName.get(fieldMetadata.getName());
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with name '" + fieldMetadata.getName() + "': in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            fieldsByNumber.put(fieldMetadata.getNumber(), fieldMetadata);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredMethods()) {
            AnnotatedElement getter;
            AnnotatedElement setter;
            String propertyName;
            if (((Method)annotatedElement).getAnnotation(ProtoUnknownFieldSet.class) != null) {
                String propertyName2;
                if (this.unknownFieldSetField != null || this.unknownFieldSetGetter != null || this.unknownFieldSetSetter != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet annotation should not be used multiple times : " + annotatedElement);
                }
                if (((Method)annotatedElement).getReturnType().equals(Void.TYPE)) {
                    if (!((Method)annotatedElement).getName().startsWith("set") || ((Method)annotatedElement).getName().length() < 4) {
                        throw new ProtoSchemaBuilderException("Illegal setter method signature: " + annotatedElement);
                    }
                    String propertyName22 = Character.toLowerCase(((Method)annotatedElement).getName().charAt(3)) + ((Method)annotatedElement).getName().substring(4);
                    if (((Method)annotatedElement).getParameterTypes().length != 1) {
                        throw new ProtoSchemaBuilderException("Illegal setter method signature: " + annotatedElement);
                    }
                    this.unknownFieldSetSetter = annotatedElement;
                    this.unknownFieldSetGetter = this.findGetter(propertyName2, ((Method)annotatedElement).getParameterTypes()[0]);
                    continue;
                }
                if (((Method)annotatedElement).getName().startsWith("get") && ((Method)annotatedElement).getName().length() >= 4) {
                    propertyName2 = Character.toLowerCase(((Method)annotatedElement).getName().charAt(3)) + ((Method)annotatedElement).getName().substring(4);
                } else if (((Method)annotatedElement).getName().startsWith("is") && ((Method)annotatedElement).getName().length() >= 3) {
                    propertyName2 = Character.toLowerCase(((Method)annotatedElement).getName().charAt(2)) + ((Method)annotatedElement).getName().substring(3);
                } else {
                    throw new ProtoSchemaBuilderException("Illegal getter method signature: " + annotatedElement);
                }
                this.unknownFieldSetGetter = annotatedElement;
                this.unknownFieldSetSetter = this.findSetter(propertyName2, this.unknownFieldSetGetter.getReturnType());
                continue;
            }
            annotation = ((Method)annotatedElement).getAnnotation(ProtoField.class);
            if (annotation == null) continue;
            if (Modifier.isPrivate(((Method)annotatedElement).getModifiers())) {
                throw new ProtoSchemaBuilderException("Private methods cannot be @ProtoField annotated: " + annotatedElement);
            }
            if (Modifier.isStatic(((Method)annotatedElement).getModifiers())) {
                throw new ProtoSchemaBuilderException("Static methods cannot be @ProtoField annotated: " + annotatedElement);
            }
            if (((Method)annotatedElement).getReturnType().equals(Void.TYPE)) {
                if (!((Method)annotatedElement).getName().startsWith("set") || ((Method)annotatedElement).getName().length() < 4) {
                    throw new ProtoSchemaBuilderException("Illegal setter method signature: " + annotatedElement);
                }
                propertyName = Character.toLowerCase(((Method)annotatedElement).getName().charAt(3)) + ((Method)annotatedElement).getName().substring(4);
                if (((Method)annotatedElement).getParameterTypes().length != 1) {
                    throw new ProtoSchemaBuilderException("Illegal setter method signature: " + annotatedElement);
                }
                setter = annotatedElement;
                getter = this.findGetter(propertyName, ((Method)annotatedElement).getParameterTypes()[0]);
            } else {
                if (((Method)annotatedElement).getName().startsWith("get") && ((Method)annotatedElement).getName().length() >= 4) {
                    propertyName = Character.toLowerCase(((Method)annotatedElement).getName().charAt(3)) + ((Method)annotatedElement).getName().substring(4);
                } else if (((Method)annotatedElement).getName().startsWith("is") && ((Method)annotatedElement).getName().length() >= 3) {
                    propertyName = Character.toLowerCase(((Method)annotatedElement).getName().charAt(2)) + ((Method)annotatedElement).getName().substring(3);
                } else {
                    throw new ProtoSchemaBuilderException("Illegal getter method signature: " + annotatedElement);
                }
                getter = annotatedElement;
                setter = this.findSetter(propertyName, ((Method)getter).getReturnType());
            }
            String fieldName = annotation.name();
            if (fieldName.isEmpty()) {
                fieldName = propertyName;
            }
            boolean isArray = ((Method)getter).getReturnType().isArray();
            boolean isRepeated = this.isRepeated(((Method)getter).getReturnType());
            boolean isRequired = annotation.required();
            if (isRepeated && isRequired) {
                throw new ProtoSchemaBuilderException("Repeated field '" + fieldName + "' of " + clazz + " cannot be marked required.");
            }
            Class<?> javaType = annotation.javaType();
            if (javaType == Void.TYPE) {
                javaType = isRepeated ? ProtoMessageTypeMetadata.determineElementType(((Method)getter).getReturnType(), ((Method)getter).getGenericReturnType()) : ((Method)getter).getReturnType();
            }
            if (!javaType.isArray() && !javaType.isPrimitive() && Modifier.isAbstract(javaType.getModifiers())) {
                throw new ProtoSchemaBuilderException("The class " + javaType.getName() + " of repeated field '" + fieldName + "' of " + clazz + " should not be abstract.");
            }
            Object defaultValue = this.getDefaultValue(clazz, fieldName, javaType, annotation.defaultValue());
            if (!isRequired && !isRepeated && javaType.isPrimitive() && defaultValue == null) {
                throw new ProtoSchemaBuilderException("Primitive field '" + fieldName + "' of " + clazz + " should be marked required or should have a default value.");
            }
            Class<?> collectionImplementation = this.getCollectionImplementation(clazz, ((Method)getter).getReturnType(), annotation.collectionImplementation(), fieldName, isRepeated);
            org.infinispan.protostream.descriptors.Type protobufType = this.getProtobufType(javaType, annotation.type());
            ProtoTypeMetadata protoTypeMetadata = null;
            if (protobufType == org.infinispan.protostream.descriptors.Type.ENUM || protobufType == org.infinispan.protostream.descriptors.Type.MESSAGE || protobufType == org.infinispan.protostream.descriptors.Type.GROUP) {
                protoTypeMetadata = this.protoSchemaGenerator.scanAnnotations(javaType);
            }
            ProtoFieldMetadata fieldMetadata = new ProtoFieldMetadata(clazz, annotation.number(), fieldName, javaType, collectionImplementation, protobufType, protoTypeMetadata, isRequired, isRepeated, isArray, defaultValue, propertyName, (Method)getter, (Method)setter);
            ProtoFieldMetadata existing = fieldsByNumber.get(annotation.number());
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with number " + annotation.number() + ": in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            existing = fieldsByName.get(fieldMetadata.getName());
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with name '" + fieldMetadata.getName() + "': in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            fieldsByNumber.put(annotation.number(), fieldMetadata);
        }
    }

    private Object getDefaultValue(Class<?> clazz, String fieldName, Class<?> fieldType, String defaultValue) {
        if (defaultValue == null || defaultValue.isEmpty()) {
            return null;
        }
        if (fieldType == String.class) {
            return "\"" + defaultValue + "\"";
        }
        if (fieldType.isEnum()) {
            ProtoEnumTypeMetadata protoEnumTypeMetadata = (ProtoEnumTypeMetadata)this.protoSchemaGenerator.scanAnnotations(fieldType);
            ProtoEnumValueMetadata enumVal = protoEnumTypeMetadata.getMemberByName(defaultValue);
            if (enumVal == null) {
                throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of type " + fieldType.getName() + " of class " + clazz.getName() + ": " + defaultValue + " is not a member of " + protoEnumTypeMetadata.getFullName());
            }
            return enumVal;
        }
        if (fieldType == Character.class || fieldType == Character.TYPE) {
            if (defaultValue.length() > 1) {
                throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of type " + fieldType.getName() + " of class " + clazz.getName() + ": " + defaultValue);
            }
            return Character.valueOf(defaultValue.charAt(0));
        }
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            return Boolean.valueOf(defaultValue);
        }
        try {
            if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                return Integer.valueOf(defaultValue);
            }
            if (fieldType == Long.class || fieldType == Long.TYPE) {
                return Long.valueOf(defaultValue);
            }
            if (fieldType == Short.class || fieldType == Short.TYPE) {
                return Short.valueOf(defaultValue);
            }
            if (fieldType == Double.class || fieldType == Double.TYPE) {
                return Double.valueOf(defaultValue);
            }
            if (fieldType == Float.class || fieldType == Float.TYPE) {
                return Float.valueOf(defaultValue);
            }
            if (fieldType == Byte.class || fieldType == Byte.TYPE) {
                return Byte.valueOf(defaultValue);
            }
            if (Date.class.isAssignableFrom(fieldType)) {
                return Long.valueOf(defaultValue);
            }
            if (Instant.class.isAssignableFrom(fieldType)) {
                return Long.valueOf(defaultValue);
            }
        }
        catch (NumberFormatException e) {
            throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of type " + fieldType.getName() + " of class " + clazz.getName() + ": " + defaultValue, e);
        }
        throw new ProtoSchemaBuilderException("No default value is allowed for field '" + fieldName + "' of " + clazz);
    }

    private Class<?> getCollectionImplementation(Class<?> clazz, Class<?> fieldType, Class<?> configuredCollection, String fieldName, boolean isRepeated) {
        Class<?> collectionImplementation;
        if (isRepeated && !fieldType.isArray()) {
            collectionImplementation = configuredCollection;
            if (collectionImplementation == Collection.class) {
                collectionImplementation = fieldType;
            }
            if (!Collection.class.isAssignableFrom(collectionImplementation)) {
                throw new ProtoSchemaBuilderException("The collection class of repeated field '" + fieldName + "' of " + clazz + " must implement java.util.Collection.");
            }
            if (Modifier.isAbstract(collectionImplementation.getModifiers())) {
                throw new ProtoSchemaBuilderException("The collection class (" + collectionImplementation.getName() + ") of repeated field '" + fieldName + "' of " + clazz + " must not be abstract. Please specify an appropriate class in collectionImplementation member.");
            }
            try {
                collectionImplementation.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ProtoSchemaBuilderException("The collection class ('" + collectionImplementation.getName() + "') of repeated field '" + fieldName + "' of " + clazz + " must have a public no-argument constructor.");
            }
            if (!fieldType.isAssignableFrom(collectionImplementation)) {
                throw new ProtoSchemaBuilderException("The collection implementation class ('" + collectionImplementation.getName() + "') of repeated field '" + fieldName + "' of " + clazz + " is not assignable to this field's type.");
            }
        } else {
            if (configuredCollection != Collection.class) {
                throw new ProtoSchemaBuilderException("Specifying the collection implementation class is only allowed for repeated/collection fields: '" + fieldName + "' of " + clazz);
            }
            collectionImplementation = null;
        }
        return collectionImplementation;
    }

    private org.infinispan.protostream.descriptors.Type getProtobufType(Class<?> javaType, org.infinispan.protostream.descriptors.Type type) {
        switch (type) {
            case MESSAGE: {
                if (javaType.isEnum()) {
                    ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                    if (!m.isEnum()) {
                        throw new ProtoSchemaBuilderException(javaType + " is not a protobuf marshallable enum type");
                    }
                    return org.infinispan.protostream.descriptors.Type.ENUM;
                }
                if (javaType == String.class) {
                    return org.infinispan.protostream.descriptors.Type.STRING;
                }
                if (javaType == Double.class || javaType == Double.TYPE) {
                    return org.infinispan.protostream.descriptors.Type.DOUBLE;
                }
                if (javaType == Float.class || javaType == Float.TYPE) {
                    return org.infinispan.protostream.descriptors.Type.FLOAT;
                }
                if (javaType == Long.class || javaType == Long.TYPE) {
                    return org.infinispan.protostream.descriptors.Type.INT64;
                }
                if (javaType == Integer.class || javaType == Integer.TYPE || javaType == Short.class || javaType == Short.TYPE || javaType == Byte.class || javaType == Byte.TYPE || javaType == Character.class || javaType == Character.TYPE) {
                    return org.infinispan.protostream.descriptors.Type.INT32;
                }
                if (javaType == Boolean.class || javaType == Boolean.TYPE) {
                    return org.infinispan.protostream.descriptors.Type.BOOL;
                }
                if (Date.class.isAssignableFrom(javaType)) {
                    return org.infinispan.protostream.descriptors.Type.FIXED64;
                }
                if (Instant.class.isAssignableFrom(javaType)) {
                    return org.infinispan.protostream.descriptors.Type.FIXED64;
                }
                ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                if (!m.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType + " is not a protobuf marshallable message type");
            }
            case ENUM: {
                if (javaType.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType + " is not a protobuf marshallable enum type");
            }
            case GROUP: {
                ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                if (!m.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType + " is not a protobuf marshallable message type");
            }
            case STRING: {
                if (javaType == String.class) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getName() + " vs " + (Object)((Object)type));
            }
            case BYTES: {
                if (javaType == byte[].class) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getName() + " vs " + (Object)((Object)type));
            }
            case DOUBLE: {
                if (javaType == Double.class || javaType == Double.TYPE) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getName() + " vs " + (Object)((Object)type));
            }
            case FLOAT: {
                if (javaType == Float.class || javaType == Float.TYPE) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getName() + " vs " + (Object)((Object)type));
            }
            case BOOL: {
                if (javaType == Boolean.class || javaType == Boolean.TYPE) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getName() + " vs " + (Object)((Object)type));
            }
            case INT32: 
            case UINT32: 
            case FIXED32: 
            case SFIXED32: 
            case SINT32: {
                if (javaType == Integer.class || javaType == Integer.TYPE) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getName() + " vs " + (Object)((Object)type));
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: {
                if (javaType == Long.class || javaType == Long.TYPE || Date.class.isAssignableFrom(javaType) || Instant.class.isAssignableFrom(javaType)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getName() + " vs " + (Object)((Object)type));
            }
        }
        return type;
    }

    private boolean isRepeated(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    private Method findGetter(String propertyName, Class<?> propertyType) {
        Method getter;
        String prefix = "get";
        if (propertyType.equals(Boolean.TYPE) || propertyType.equals(Boolean.class)) {
            prefix = "is";
        }
        String methodName = prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            getter = this.javaClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ProtoSchemaBuilderException("No getter method found for property '" + propertyName + "' of type " + propertyType + " in class " + this.javaClass.getName());
        }
        if (!getter.getReturnType().equals(propertyType)) {
            throw new ProtoSchemaBuilderException("No suitable getter method found for property '" + propertyName + "' of type " + propertyType + " in class " + this.javaClass.getName() + ". The candidate method does not have a suitable return type: " + getter);
        }
        return getter;
    }

    private Method findSetter(String propertyName, Class<?> propertyType) {
        Method setter;
        String methodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            setter = this.javaClass.getMethod(methodName, propertyType);
        }
        catch (NoSuchMethodException e) {
            throw new ProtoSchemaBuilderException("No setter method found for property '" + propertyName + "' of type " + propertyType + " in class " + this.javaClass.getName());
        }
        if (!setter.getReturnType().equals(Void.TYPE)) {
            throw new ProtoSchemaBuilderException("No suitable setter method found for property '" + propertyName + "' of type " + propertyType + " in class " + this.javaClass.getName() + ". The candidate method does not have a suitable return type: " + setter);
        }
        return setter;
    }

    private static Class<?> determineElementType(Class<?> type, Type genericType) {
        if (type.isArray()) {
            return type.getComponentType();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ProtoMessageTypeMetadata.determineCollectionElementType(genericType);
        }
        return null;
    }

    private static Class<?> determineCollectionElementType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            Type fieldArgType = type.getActualTypeArguments()[0];
            if (fieldArgType instanceof Class) {
                return (Class)fieldArgType;
            }
            return (Class)((ParameterizedType)fieldArgType).getRawType();
        }
        if (genericType instanceof Class) {
            Class<?> x;
            Class c = (Class)genericType;
            if (c.getGenericSuperclass() != null && Collection.class.isAssignableFrom(c.getSuperclass()) && (x = ProtoMessageTypeMetadata.determineCollectionElementType(c.getGenericSuperclass())) != null) {
                return x;
            }
            for (Type t : c.getGenericInterfaces()) {
                Class<?> x2;
                if ((!(t instanceof Class) || !Map.class.isAssignableFrom((Class)t)) && (!(t instanceof ParameterizedType) || !Collection.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) || (x2 = ProtoMessageTypeMetadata.determineCollectionElementType(t)) == null) continue;
                return x2;
            }
        }
        return null;
    }
}

