/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SslConfiguration;

public class SslConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<SslConfiguration> {
    private static final Log log = LogFactory.getLog(SslConfigurationBuilder.class);

    protected SslConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, SslConfiguration.attributeDefinitionSet());
    }

    public SslConfigurationBuilder disable() {
        this.attributes.attribute(SslConfiguration.ENABLED).set(false);
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.attributes.attribute(SslConfiguration.ENABLED).set(true);
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(SslConfiguration.ENABLED).set(enabled);
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.attributes.attribute(SslConfiguration.KEYSTORE_FILENAME).set(keyStoreFileName);
        return this;
    }

    public SslConfigurationBuilder keyStoreType(String keyStoreType) {
        this.attributes.attribute(SslConfiguration.KEYSTORE_TYPE).set(keyStoreType);
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.attributes.attribute(SslConfiguration.KEYSTORE_PASSWORD).set(new String(keyStorePassword));
        return this;
    }

    public SslConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.attributes.attribute(SslConfiguration.KEYSTORE_CERTIFICATE_PASSWORD).set(new String(keyStoreCertificatePassword));
        return this;
    }

    public SslConfigurationBuilder keyAlias(String keyAlias) {
        this.attributes.attribute(SslConfiguration.KEY_ALIAS).set(keyAlias);
        return this;
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.attributes.attribute(SslConfiguration.SSL_CONTEXT).set(sslContext);
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.attributes.attribute(SslConfiguration.TRUSTSTORE_FILENAME).set(trustStoreFileName);
        return this;
    }

    public SslConfigurationBuilder trustStoreType(String trustStoreType) {
        this.attributes.attribute(SslConfiguration.TRUSTSTORE_TYPE).set(trustStoreType);
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.attributes.attribute(SslConfiguration.TRUSTSTORE_PASSWORD).set(new String(trustStorePassword));
        return this;
    }

    public SslConfigurationBuilder sniHostName(String sniHostName) {
        this.attributes.attribute(SslConfiguration.SNI_HOSTNAME).set(sniHostName);
        return this;
    }

    public SslConfigurationBuilder protocol(String protocol) {
        this.attributes.attribute(SslConfiguration.PROTOCOL).set(protocol);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public SslConfiguration create() {
        return new SslConfiguration(this.attributes.protect());
    }

    public SslConfigurationBuilder read(SslConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

