/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.AuthenticationConfiguration;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;

public class AuthenticationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthenticationConfiguration> {
    private static final Log log = LogFactory.getLog(AuthenticationConfigurationBuilder.class);
    private String username;
    private char[] password;
    private String realm;

    public AuthenticationConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, AuthenticationConfiguration.attributeDefinitionSet());
    }

    public AuthenticationConfigurationBuilder callbackHandler(CallbackHandler callbackHandler) {
        this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER).set(callbackHandler);
        return this;
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthenticationConfiguration.ENABLED).set(enabled);
        return this;
    }

    public AuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public AuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public AuthenticationConfigurationBuilder saslMechanism(String saslMechanism) {
        this.attributes.attribute(AuthenticationConfiguration.SASL_MECHANISM).set(saslMechanism);
        return this;
    }

    public AuthenticationConfigurationBuilder saslProperties(Map<String, String> saslProperties) {
        this.attributes.attribute(AuthenticationConfiguration.SASL_PROPERTIES).set(saslProperties);
        return this;
    }

    public AuthenticationConfigurationBuilder serverName(String serverName) {
        this.attributes.attribute(AuthenticationConfiguration.SERVER_NAME).set(serverName);
        return this;
    }

    public AuthenticationConfigurationBuilder clientSubject(Subject clientSubject) {
        this.attributes.attribute(AuthenticationConfiguration.CLIENT_SUBJECT).set(clientSubject);
        return this;
    }

    public AuthenticationConfigurationBuilder username(String username) {
        this.attributes.attribute(AuthenticationConfiguration.USERNAME).set(username);
        return this;
    }

    public AuthenticationConfigurationBuilder password(String password) {
        this.attributes.attribute(AuthenticationConfiguration.PASSWORD).set(password);
        return this;
    }

    public AuthenticationConfigurationBuilder password(char[] password) {
        this.password(new String(password));
        return this;
    }

    public AuthenticationConfigurationBuilder realm(String realm) {
        this.attributes.attribute(AuthenticationConfiguration.REALM).set(realm);
        return this;
    }

    @Override
    public AuthenticationConfiguration create() {
        return new AuthenticationConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(AuthenticationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    @Override
    public void validate() {
    }
}

