/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.notifications.cachelistener.QueueingSegmentListener;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

abstract class BaseQueueingSegmentListener<K, V, E extends Event<K, V>>
implements QueueingSegmentListener<K, V, E> {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected boolean trace = log.isTraceEnabled();
    protected final AtomicBoolean completed = new AtomicBoolean(false);
    protected final ConcurrentMap<K, Object> notifiedKeys = new ConcurrentHashMap<K, Object>();

    protected BaseQueueingSegmentListener() {
    }

    @Override
    public Object markKeyAsProcessing(K key) {
        Object value = this.notifiedKeys.put(key, NOTIFIED);
        if (value != null && this.trace) {
            log.tracef("Processing key %s as a concurrent update occurred with value %s", (Object)key, value);
        }
        return value;
    }

    @Override
    public Set<CacheEntry<K, V>> findCreatedEntries() {
        HashSet<CacheEntry<K, V>> set = new HashSet<CacheEntry<K, V>>();
        for (Map.Entry entry : this.notifiedKeys.entrySet()) {
            Object value = entry.getValue();
            if (value == NOTIFIED) continue;
            Object key = entry.getKey();
            Object replaceValue = value;
            while (replaceValue != NOTIFIED && !this.notifiedKeys.replace(key, replaceValue, NOTIFIED)) {
                replaceValue = this.notifiedKeys.get(key);
            }
            if (replaceValue == NOTIFIED || replaceValue == REMOVED) continue;
            set.add((CacheEntry)replaceValue);
        }
        return set;
    }

    @Override
    public void notifiedKey(K key) {
    }

    @Override
    public void segmentCompleted(Set<Integer> segments) {
    }

    protected boolean addEvent(K key, Object value) {
        Object nowPrevious;
        Object prevEvent = this.notifiedKeys.get(key);
        boolean returnValue = prevEvent == null ? ((nowPrevious = this.notifiedKeys.putIfAbsent(key, value)) == null ? true : (nowPrevious != NOTIFIED ? this.addEvent(key, value) : false)) : (prevEvent != NOTIFIED ? (this.notifiedKeys.replace(key, prevEvent, value) ? true : this.addEvent(key, value)) : false);
        return returnValue;
    }
}

