/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.util.ReadOnlySegmentAwareCollection;
import org.infinispan.distribution.util.ReadOnlySegmentAwareEntryCollection;
import org.infinispan.util.AbstractDelegatingCollection;
import org.infinispan.util.AbstractDelegatingMap;

public class ReadOnlySegmentAwareMap<K, V>
extends AbstractDelegatingMap<K, V> {
    protected final Map<K, V> map;
    protected final ConsistentHash ch;
    protected final Set<Integer> allowedSegments;
    protected Set<K> segmentAwareKeySet;
    protected Set<Map.Entry<K, V>> segmentAwareEntrySet;

    public ReadOnlySegmentAwareMap(Map<K, V> map, ConsistentHash ch, Set<Integer> allowedSegments) {
        this.map = Collections.unmodifiableMap(map);
        this.ch = ch;
        this.allowedSegments = allowedSegments;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.map;
    }

    protected boolean keyAllowed(Object key) {
        int segment = this.ch.getSegment(key);
        return this.allowedSegments.contains(segment);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.keyAllowed(key)) {
            return super.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.keyAllowed(key)) {
            return super.get(key);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.segmentAwareEntrySet == null) {
            this.segmentAwareEntrySet = new CollectionAsSet<Map.Entry<K, V>>(new ReadOnlySegmentAwareEntryCollection<K, V>(this.delegate().entrySet(), this.ch, this.allowedSegments));
        }
        return this.segmentAwareEntrySet;
    }

    @Override
    public boolean isEmpty() {
        Set<K> keySet = this.keySet();
        Iterator<K> iter = keySet.iterator();
        return !iter.hasNext();
    }

    @Override
    public Set<K> keySet() {
        if (this.segmentAwareKeySet == null) {
            this.segmentAwareKeySet = new CollectionAsSet(new ReadOnlySegmentAwareCollection(super.keySet(), this.ch, this.allowedSegments));
        }
        return this.segmentAwareKeySet;
    }

    @Override
    public int size() {
        Set<K> keySet = this.keySet();
        Iterator<K> iter = keySet.iterator();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ReadOnlySegmentAwareMap [map=" + this.map + ", ch=" + this.ch + ", allowedSegments=" + this.allowedSegments + "]";
    }

    private static class CollectionAsSet<T>
    extends AbstractDelegatingCollection<T>
    implements Set<T> {
        private final AbstractDelegatingCollection<T> delegate;

        public CollectionAsSet(AbstractDelegatingCollection<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected Collection<T> delegate() {
            return this.delegate;
        }
    }
}

