/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.AbstractConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;

@Immutable
public class DefaultConsistentHash
extends AbstractConsistentHash {
    private static final String STATE_NUM_OWNERS = "numOwners";
    private static final String STATE_SEGMENT_OWNER = "segmentOwner.%d.%d";
    private static final String STATE_SEGMENT_OWNERS = "segmentOwners";
    private static final String STATE_SEGMENT_OWNER_COUNT = "segmentOwner.%d.num";
    private final int numOwners;
    private final List<Address>[] segmentOwners;

    public DefaultConsistentHash(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners) {
        super(hashFunction, numSegments, members, capacityFactors);
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numOwners = numOwners;
        this.segmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            if (segmentOwners[i] == null || segmentOwners[i].isEmpty()) {
                throw new IllegalArgumentException("Segment owner list cannot be null or empty");
            }
            this.segmentOwners[i] = Immutables.immutableListCopy(segmentOwners[i]);
        }
    }

    private DefaultConsistentHash(Hash hashFunction, int numOwners, int numSegments, List<Address> members, float[] capacityFactors, List<Address>[] segmentOwners) {
        super(hashFunction, numSegments, members, capacityFactors);
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numOwners = numOwners;
        for (int i = 0; i < numSegments; ++i) {
            if (segmentOwners[i] != null && segmentOwners[i].size() != 0) continue;
            throw new IllegalArgumentException("Segment owner list cannot be null or empty");
        }
        this.segmentOwners = segmentOwners;
    }

    DefaultConsistentHash(ScopedPersistentState state) {
        super(state);
        this.numOwners = Integer.parseInt(state.getProperty(STATE_NUM_OWNERS));
        int numSegments = DefaultConsistentHash.parseNumSegments(state);
        this.segmentOwners = new List[numSegments];
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            int segmentOwnerCount = Integer.parseInt(state.getProperty(String.format(STATE_SEGMENT_OWNER_COUNT, i)));
            this.segmentOwners[i] = new ArrayList<Address>();
            for (int j = 0; j < segmentOwnerCount; ++j) {
                PersistentUUID uuid = PersistentUUID.fromString(state.getProperty(String.format(STATE_SEGMENT_OWNER, i, j)));
                this.segmentOwners[i].add(uuid);
            }
        }
    }

    @Override
    public int getNumSegments() {
        return this.segmentOwners.length;
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            throw new IllegalArgumentException("Node " + owner + " is not a member");
        }
        SmallIntSet segments = new SmallIntSet(this.segmentOwners.length);
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!this.segmentOwners[segment].contains(owner)) continue;
            segments.add(Integer.valueOf(segment));
        }
        return segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            throw new IllegalArgumentException("Node " + owner + " is not a member");
        }
        SmallIntSet segments = new SmallIntSet(this.segmentOwners.length);
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!owner.equals(this.segmentOwners[segment].get(0))) continue;
            segments.add(segment);
        }
        return segments;
    }

    @Deprecated
    public List<Integer> getSegmentEndHashes() {
        int numSegments = this.segmentOwners.length;
        ArrayList<Integer> hashes = new ArrayList<Integer>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            hashes.add((i + 1) % numSegments * this.segmentSize);
        }
        return hashes;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.segmentOwners[segmentId];
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.segmentOwners[segmentId].get(0);
    }

    @Override
    public int getNumOwners() {
        return this.numOwners;
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.segmentOwners[segmentId].contains(nodeAddress);
    }

    public int hashCode() {
        int result = this.numOwners;
        result = 31 * result + this.members.hashCode();
        result = 31 * result + Arrays.hashCode(this.segmentOwners);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.segmentOwners.length != that.segmentOwners.length) {
            return false;
        }
        if (!this.hashFunction.equals(that.hashFunction)) {
            return false;
        }
        if (!this.members.equals(that.members)) {
            return false;
        }
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            if (this.segmentOwners[i].equals(that.segmentOwners[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        OwnershipStatistics stats = new OwnershipStatistics(this, this.members);
        StringBuilder sb = new StringBuilder("DefaultConsistentHash{");
        sb.append("ns=").append(this.segmentOwners.length);
        sb.append(", owners = (").append(this.members.size()).append(")[");
        boolean first = true;
        for (Address a : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            int primaryOwned = stats.getPrimaryOwned(a);
            int owned = stats.getOwned(a);
            sb.append(a).append(": ").append(primaryOwned).append('+').append(owned - primaryOwned);
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (Address a : this.members) {
            if (sb.length() > 0) {
                sb.append("\n  ");
            }
            Set<Integer> primarySegments = this.getPrimarySegmentsForOwner(a);
            sb.append(a).append(" primary: ").append(primarySegments);
            Set<Integer> backupSegments = this.getSegmentsForOwner(a);
            backupSegments.removeAll(primarySegments);
            sb.append(", backup: ").append(backupSegments);
        }
        return sb.toString();
    }

    public DefaultConsistentHash union(DefaultConsistentHash dch2) {
        this.checkSameHashAndSegments(dch2);
        if (this.numOwners != dch2.getNumOwners()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of owners");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.members);
        DefaultConsistentHash.mergeLists(unionMembers, dch2.getMembers());
        List[] unionSegmentOwners = new List[this.segmentOwners.length];
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            unionSegmentOwners[i] = new ArrayList<Address>(this.locateOwnersForSegment(i));
            DefaultConsistentHash.mergeLists(unionSegmentOwners[i], dch2.locateOwnersForSegment(i));
        }
        Map<Address, Float> unionCapacityFactors = this.unionCapacityFactors(dch2);
        return new DefaultConsistentHash(this.hashFunction, this.numOwners, unionSegmentOwners.length, unionMembers, unionCapacityFactors, unionSegmentOwners);
    }

    public String prettyPrintOwnership() {
        StringBuilder sb = new StringBuilder();
        for (Address member : this.getMembers()) {
            sb.append("\n").append(member).append(":");
            for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
                int index = this.segmentOwners[segment].indexOf(member);
                if (index < 0) continue;
                sb.append(' ').append(segment);
                if (index != 0) continue;
                sb.append('\'');
            }
        }
        return sb.toString();
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        super.toScopedState(state);
        state.setProperty(STATE_NUM_OWNERS, this.numOwners);
        state.setProperty(STATE_SEGMENT_OWNERS, this.segmentOwners.length);
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            List<Address> segmentOwnerAddresses = this.segmentOwners[i];
            state.setProperty(String.format(STATE_SEGMENT_OWNER_COUNT, i), segmentOwnerAddresses.size());
            for (int j = 0; j < segmentOwnerAddresses.size(); ++j) {
                state.setProperty(String.format(STATE_SEGMENT_OWNER, i, j), segmentOwnerAddresses.get(j).toString());
            }
        }
    }

    @Override
    public ConsistentHash remapAddresses(UnaryOperator<Address> remapper) {
        List<Address> remappedMembers = this.remapMembers(remapper);
        if (remappedMembers == null) {
            return null;
        }
        Map<Address, Float> remappedCapacityFactors = this.remapCapacityFactors(remapper);
        List[] remappedSegmentOwners = new List[this.segmentOwners.length];
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            ArrayList remappedOwners = new ArrayList(this.segmentOwners[i].size());
            for (Address address : this.segmentOwners[i]) {
                remappedOwners.add(remapper.apply(address));
            }
            remappedSegmentOwners[i] = remappedOwners;
        }
        return new DefaultConsistentHash(this.hashFunction, this.numOwners, this.segmentOwners.length, remappedMembers, remappedCapacityFactors, remappedSegmentOwners);
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<DefaultConsistentHash> {
        @Override
        public void doWriteObject(ObjectOutput output, DefaultConsistentHash ch) throws IOException {
            output.writeInt(ch.segmentOwners.length);
            output.writeInt(ch.numOwners);
            output.writeObject(ch.members);
            output.writeObject(ch.capacityFactors);
            output.writeObject(ch.hashFunction);
            HashMap<Address, Integer> memberIndexes = this.getMemberIndexMap(ch.members);
            for (int i = 0; i < ch.segmentOwners.length; ++i) {
                List owners = ch.segmentOwners[i];
                output.writeInt(owners.size());
                for (Address owner : owners) {
                    output.writeInt(memberIndexes.get(owner));
                }
            }
        }

        @Override
        public DefaultConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int numSegments = unmarshaller.readInt();
            int numOwners = unmarshaller.readInt();
            List members = (List)unmarshaller.readObject();
            float[] capacityFactors = (float[])unmarshaller.readObject();
            Hash hash = (Hash)unmarshaller.readObject();
            List[] segmentOwners = new List[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                int size = unmarshaller.readInt();
                Address[] owners = new Address[size];
                for (int j = 0; j < size; ++j) {
                    int ownerIndex = unmarshaller.readInt();
                    owners[j] = (Address)members.get(ownerIndex);
                }
                segmentOwners[i] = Immutables.immutableListWrap(owners);
            }
            return new DefaultConsistentHash(hash, numOwners, numSegments, members, capacityFactors, segmentOwners);
        }

        private HashMap<Address, Integer> getMemberIndexMap(List<Address> members) {
            HashMap<Address, Integer> memberIndexes = new HashMap<Address, Integer>(members.size());
            for (int i = 0; i < members.size(); ++i) {
                memberIndexes.put(members.get(i), i);
            }
            return memberIndexes;
        }

        @Override
        public Integer getId() {
            return 27;
        }

        @Override
        public Set<Class<? extends DefaultConsistentHash>> getTypeClasses() {
            return Collections.singleton(DefaultConsistentHash.class);
        }
    }
}

