/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.jboss.marshalling.ClassResolver;

public class SerializationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<SerializationConfiguration> {
    private final AttributeSet attributes;
    private Map<Integer, AdvancedExternalizer<?>> advancedExternalizers = new HashMap();

    SerializationConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.attributes = SerializationConfiguration.attributeDefinitionSet();
    }

    public SerializationConfigurationBuilder marshaller(Marshaller marshaller) {
        this.attributes.attribute(SerializationConfiguration.MARSHALLER).set(marshaller);
        return this;
    }

    public Marshaller getMarshaller() {
        return this.attributes.attribute(SerializationConfiguration.MARSHALLER).get();
    }

    public SerializationConfigurationBuilder version(short marshallVersion) {
        this.attributes.attribute(SerializationConfiguration.VERSION).set(marshallVersion);
        return this;
    }

    public SerializationConfigurationBuilder version(String marshallVersion) {
        this.version(Version.getVersionShort(marshallVersion));
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(int id, AdvancedExternalizer<T> advancedExternalizer) {
        AdvancedExternalizer<?> ext = this.advancedExternalizers.get(id);
        if (ext != null) {
            throw new CacheConfigurationException(String.format("Duplicate externalizer id found! Externalizer id=%d for %s is shared by another externalizer (%s)", id, advancedExternalizer.getClass().getName(), ext.getClass().getName()));
        }
        this.advancedExternalizers.put(id, advancedExternalizer);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> advancedExternalizer) {
        Integer id = advancedExternalizer.getId();
        if (id == null) {
            throw new CacheConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", advancedExternalizer.getClass().getName()));
        }
        this.addAdvancedExternalizer(id, advancedExternalizer);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> ... advancedExternalizers) {
        for (AdvancedExternalizer<T> advancedExternalizer : advancedExternalizers) {
            this.addAdvancedExternalizer(advancedExternalizer);
        }
        return this;
    }

    public SerializationConfigurationBuilder classResolver(ClassResolver classResolver) {
        this.attributes.attribute(SerializationConfiguration.CLASS_RESOLVER).set(classResolver);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public SerializationConfiguration create() {
        return new SerializationConfiguration(this.attributes.protect(), this.advancedExternalizers);
    }

    public SerializationConfigurationBuilder read(SerializationConfiguration template) {
        this.attributes.read(template.attributes());
        this.advancedExternalizers = template.advancedExternalizers();
        return this;
    }

    public String toString() {
        return "SerializationConfigurationBuilder [attributes=" + this.attributes + ", advancedExternalizers=" + this.advancedExternalizers + "]";
    }
}

