/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<StateTransferConfiguration> {
    private static final Log log = LogFactory.getLog(StateTransferConfigurationBuilder.class);
    private final AttributeSet attributes = StateTransferConfiguration.attributeDefinitionSet();

    StateTransferConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public StateTransferConfigurationBuilder fetchInMemoryState(boolean b) {
        this.attributes.attribute(StateTransferConfiguration.FETCH_IN_MEMORY_STATE).set(b);
        return this;
    }

    public StateTransferConfigurationBuilder awaitInitialTransfer(boolean b) {
        this.attributes.attribute(StateTransferConfiguration.AWAIT_INITIAL_TRANSFER).set(b);
        return this;
    }

    public StateTransferConfigurationBuilder chunkSize(int i) {
        this.attributes.attribute(StateTransferConfiguration.CHUNK_SIZE).set(i);
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l) {
        this.attributes.attribute(StateTransferConfiguration.TIMEOUT).set(l);
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l, TimeUnit unit) {
        return this.timeout(unit.toMillis(l));
    }

    @Override
    public void validate() {
        Attribute<Boolean> fetchAttribute;
        if (this.attributes.attribute(StateTransferConfiguration.CHUNK_SIZE).get() <= 0) {
            throw new CacheConfigurationException("chunkSize can not be <= 0");
        }
        if (this.clustering().cacheMode().isInvalidation() && (fetchAttribute = this.attributes.attribute(StateTransferConfiguration.FETCH_IN_MEMORY_STATE)).isModified() && fetchAttribute.get().booleanValue()) {
            throw log.attributeNotAllowedInInvalidationMode(StateTransferConfiguration.FETCH_IN_MEMORY_STATE.name());
        }
        Attribute<Boolean> awaitInitialTransfer = this.attributes.attribute(StateTransferConfiguration.AWAIT_INITIAL_TRANSFER);
        if (awaitInitialTransfer.isModified() && awaitInitialTransfer.get().booleanValue() && !this.getClusteringBuilder().cacheMode().needsStateTransfer()) {
            throw log.awaitInitialTransferOnlyForDistOrRepl();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public StateTransferConfiguration create() {
        return new StateTransferConfiguration(this.attributes.protect());
    }

    public StateTransferConfigurationBuilder read(StateTransferConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "StateTransferConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

