/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import java.util.UUID;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public abstract class TransactionManagerImpl
implements TransactionManager {
    private static final Log log = LogFactory.getLog(TransactionManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static ThreadLocal<Transaction> CURRENT_TRANSACTION = new ThreadLocal();
    protected final UUID transactionManagerId = UUID.randomUUID();

    public static void dissociateTransaction() {
        CURRENT_TRANSACTION.remove();
    }

    static void associateTransaction(Transaction tx) {
        CURRENT_TRANSACTION.set(tx);
    }

    public Transaction getTransaction() {
        return CURRENT_TRANSACTION.get();
    }

    public void begin() throws NotSupportedException, SystemException {
        Transaction currentTx = this.getTransaction();
        if (currentTx != null) {
            throw new NotSupportedException(Thread.currentThread() + " is already associated with a transaction (" + currentTx + ")");
        }
        TransactionManagerImpl.associateTransaction(this.createTransaction());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getTransactionAndFailIfNone().commit();
        TransactionManagerImpl.dissociateTransaction();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getTransactionAndFailIfNone().rollback();
        TransactionManagerImpl.dissociateTransaction();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransactionAndFailIfNone().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        TransactionManagerImpl.dissociateTransaction();
        if (trace) {
            log.tracef("Suspending tx %s", (Object)tx);
        }
        return tx;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (trace) {
            log.tracef("Resuming tx %s", (Object)tx);
        }
        TransactionManagerImpl.associateTransaction(tx);
    }

    protected abstract Transaction createTransaction();

    private Transaction getTransactionAndFailIfNone() {
        Transaction transaction = CURRENT_TRANSACTION.get();
        if (transaction == null) {
            throw new IllegalStateException("no transaction associated with calling thread");
        }
        return transaction;
    }
}

