/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.concurrent.CompletableFutures;

public class RemoveCacheCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 18;
    private EmbeddedCacheManager cacheManager;

    private RemoveCacheCommand() {
        super(null);
    }

    public RemoveCacheCommand(ByteString cacheName, EmbeddedCacheManager cacheManager) {
        super(cacheName);
        this.cacheManager = cacheManager;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        GlobalComponentRegistry globalComponentRegistry = this.cacheManager.getGlobalComponentRegistry();
        ComponentRegistry cacheComponentRegistry = globalComponentRegistry.getNamedComponentRegistry(this.cacheName);
        String name = this.cacheName.toString();
        if (cacheComponentRegistry != null) {
            cacheComponentRegistry.getComponent(PersistenceManager.class).setClearOnStop(true);
            cacheComponentRegistry.getComponent(CacheJmxRegistration.class).setUnregisterCacheMBean(true);
            cacheComponentRegistry.getComponent(PassivationManager.class).skipPassivationOnStop(true);
            Cache cache = this.cacheManager.getCache(name, false);
            if (cache != null) {
                cache.stop();
            }
        }
        globalComponentRegistry.removeCache(name);
        globalComponentRegistry.getComponent(ConfigurationManager.class).removeConfiguration(name);
        globalComponentRegistry.getComponent(DependencyGraph.class, "org.infinispan.CacheDependencyGraph").remove(this.cacheName);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 18;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return "RemoveCacheCommand{cacheName='" + this.cacheName + '\'' + '}';
    }
}

