/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Util;
import org.jboss.logging.BasicLogger;

public class ConsistentHashV2
implements ConsistentHash {
    private static final BasicLogger log = LogFactory.getLog(ConsistentHashV2.class);
    private final SortedMap<Integer, SocketAddress> positions = new TreeMap<Integer, SocketAddress>();
    private volatile int[] hashes;
    private volatile SocketAddress[] addresses;
    private int hashSpace;
    private boolean hashSpaceIsMaxInt;
    protected Hash hash = MurmurHash3.getInstance();
    private int numKeyOwners;
    private final Random rnd;

    public ConsistentHashV2(Random rnd) {
        this.rnd = rnd;
    }

    public ConsistentHashV2() {
        this(new Random());
    }

    @Override
    public void init(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, int hashSpace) {
        for (Map.Entry<SocketAddress, Set<Integer>> entry : servers2Hash.entrySet()) {
            SocketAddress addr = entry.getKey();
            for (Integer hash : entry.getValue()) {
                SocketAddress prev = this.positions.put(hash, addr);
                if (prev == null) continue;
                log.debugf("Adding hash (%d) again, this time for %s. Previously it was associated with: %s", (Object)hash, (Object)addr, (Object)prev);
            }
        }
        int hashWheelSize = this.positions.size();
        log.tracef("Positions (%d entries) are: %s", hashWheelSize, (Object)this.positions);
        this.hashes = new int[hashWheelSize];
        Iterator<Integer> it = this.positions.keySet().iterator();
        for (int i = 0; i < hashWheelSize; ++i) {
            this.hashes[i] = it.next();
        }
        this.addresses = this.positions.values().toArray(new SocketAddress[hashWheelSize]);
        this.hashSpace = hashSpace;
        this.hashSpaceIsMaxInt = hashSpace == Integer.MAX_VALUE;
        this.numKeyOwners = numKeyOwners;
    }

    @Override
    public SocketAddress getServer(Object key) {
        int normalisedHashForKey;
        if (this.hashSpaceIsMaxInt) {
            normalisedHashForKey = this.getNormalizedHash(key);
            if (normalisedHashForKey == Integer.MAX_VALUE) {
                normalisedHashForKey = 0;
            }
        } else {
            normalisedHashForKey = this.getNormalizedHash(key) % this.hashSpace;
        }
        int mainOwner = this.getHashIndex(normalisedHashForKey);
        int indexToReturn = mainOwner % this.hashes.length;
        return this.addresses[indexToReturn];
    }

    private int getHashIndex(int normalisedHashForKey) {
        int result = Arrays.binarySearch(this.hashes, normalisedHashForKey);
        if (result >= 0) {
            return result;
        }
        if (result == -this.hashes.length - 1) {
            return 0;
        }
        return -result - 1;
    }

    private int getIndex() {
        return this.rnd.nextInt(Math.min(this.numKeyOwners, this.positions.size()));
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Override
    public final int getNormalizedHash(Object object) {
        return Util.getNormalizedHash(object, this.hash);
    }

    @Override
    public Map<SocketAddress, Set<Integer>> getSegmentsByServer() {
        throw new UnsupportedOperationException();
    }
}

