/*
 * Decompiled with CFR 0.152.
 */
package infinispan.net.oauth;

import infinispan.net.oauth.OAuthException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthProblemException
extends OAuthException {
    public static final String OAUTH_PROBLEM = "oauth_problem";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private static final long serialVersionUID = 1L;

    public OAuthProblemException() {
    }

    public OAuthProblemException(String problem) {
        super(problem);
        if (problem != null) {
            this.parameters.put(OAUTH_PROBLEM, problem);
        }
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null) {
            return msg;
        }
        msg = this.getProblem();
        if (msg != null) {
            return msg;
        }
        Object response = this.getParameters().get("HTTP response");
        if (response != null) {
            msg = response.toString();
            int eol = msg.indexOf("\n");
            if (eol < 0) {
                eol = msg.indexOf("\r");
            }
            if (eol >= 0) {
                msg = msg.substring(0, eol);
            }
            if ((msg = msg.trim()).length() > 0) {
                return msg;
            }
        }
        if ((response = Integer.valueOf(this.getHttpStatusCode())) != null) {
            return "HTTP status " + response;
        }
        return null;
    }

    public void setParameter(String name, Object value) {
        this.getParameters().put(name, value);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getProblem() {
        return (String)this.getParameters().get(OAUTH_PROBLEM);
    }

    public int getHttpStatusCode() {
        Object code = this.getParameters().get("HTTP status");
        if (code == null) {
            return 200;
        }
        if (code instanceof Number) {
            return ((Number)code).intValue();
        }
        return Integer.parseInt(code.toString());
    }
}

