/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.io.IOException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.query.backend.TransactionHelper;
import org.infinispan.query.indexmanager.IndexLockController;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class IndexManagerBasedLockController
implements IndexLockController {
    private static final Log log = (Log)LogFactory.getLog(IndexManagerBasedLockController.class, Log.class);
    private final DirectoryBasedIndexManager indexManager;
    private final TransactionHelper transactionHelper;

    public IndexManagerBasedLockController(DirectoryBasedIndexManager indexManager, TransactionManager tm) {
        this.indexManager = indexManager;
        this.transactionHelper = new TransactionHelper(tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForAvailability() {
        Transaction tx = this.transactionHelper.suspendTxIfExists();
        try {
            boolean waitForAvailabilityInternal = this.waitForAvailabilityInternal();
            log.waitingForLockAcquired(waitForAvailabilityInternal);
            boolean bl = waitForAvailabilityInternal;
            return bl;
        }
        finally {
            this.transactionHelper.resume(tx);
        }
    }

    private boolean waitForAvailabilityInternal() {
        Object directory = this.indexManager.getDirectoryProvider().getDirectory();
        try {
            Lock lock = ((Directory)directory).obtainLock("write.lock");
            lock.close();
            return true;
        }
        catch (LockObtainFailedException lofe) {
            return false;
        }
        catch (IOException e) {
            log.error(e);
            return false;
        }
    }

    @Override
    public void forceLockClear() {
        Transaction tx = this.transactionHelper.suspendTxIfExists();
        try {
            this.forceLockClearInternal();
        }
        finally {
            this.transactionHelper.resume(tx);
        }
    }

    private void forceLockClearInternal() {
        Object directory = this.indexManager.getDirectoryProvider().getDirectory();
        log.warn("Forcing clear of index lock");
        ((DirectoryExtensions)directory).forceUnlock("write.lock");
    }
}

