/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.continuous.impl.ContinuousQueryResult;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class IckleContinuousQueryCacheEventFilterConverter<K, V, C>
extends AbstractCacheEventFilterConverter<K, V, C>
implements IndexedFilter<K, V, C> {
    protected final String queryString;
    protected final Map<String, Object> namedParameters;
    protected Class<? extends Matcher> matcherImplClass;
    protected QueryCache queryCache;
    protected Matcher matcher;
    protected ObjectFilter objectFilter;

    public IckleContinuousQueryCacheEventFilterConverter(String queryString, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        if (queryString == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.queryString = queryString;
        this.namedParameters = namedParameters;
        this.matcherImplClass = matcherImplClass;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    @Inject
    protected void injectDependencies(Cache cache) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        this.queryCache = (QueryCache)componentRegistry.getComponent(QueryCache.class);
        this.matcher = (Matcher)componentRegistry.getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
    }

    protected ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            this.objectFilter = this.queryCache != null ? this.queryCache.get(this.queryString, null, this.matcherImplClass, (qs, accumulators) -> this.matcher.getObjectFilter(qs)) : this.matcher.getObjectFilter(this.queryString);
        }
        return this.namedParameters != null ? this.objectFilter.withParameters(this.namedParameters) : this.objectFilter;
    }

    public C filterAndConvert(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        ObjectFilter.FilterResult f2;
        if (eventType.isExpired()) {
            oldValue = newValue;
            newValue = null;
        }
        ObjectFilter objectFilter = this.getObjectFilter();
        ObjectFilter.FilterResult f1 = oldValue == null ? null : objectFilter.filter(oldValue);
        ObjectFilter.FilterResult filterResult = f2 = newValue == null ? null : objectFilter.filter(newValue);
        if (f1 == null) {
            if (f2 != null) {
                return (C)new ContinuousQueryResult<V>(ContinuousQueryResult.ResultType.JOINING, f2.getProjection() == null ? newValue : null, f2.getProjection());
            }
        } else {
            if (f2 != null) {
                return (C)new ContinuousQueryResult<V>(ContinuousQueryResult.ResultType.UPDATED, f2.getProjection() == null ? newValue : null, f2.getProjection());
            }
            return (C)new ContinuousQueryResult<Object>(ContinuousQueryResult.ResultType.LEAVING, null, null);
        }
        return null;
    }

    public String toString() {
        return "IckleContinuousQueryCacheEventFilterConverter{queryString='" + this.queryString + "'}";
    }

    public static final class Externalizer
    extends AbstractExternalizer<IckleContinuousQueryCacheEventFilterConverter> {
        public void writeObject(ObjectOutput output, IckleContinuousQueryCacheEventFilterConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.queryString);
            Map<String, Object> namedParameters = filterAndConverter.namedParameters;
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry<String, Object> e : namedParameters.entrySet()) {
                    output.writeUTF(e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public IckleContinuousQueryCacheEventFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String queryString = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            Class matcherImplClass = (Class)input.readObject();
            return new IckleContinuousQueryCacheEventFilterConverter(queryString, namedParameters, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER;
        }

        public Set<Class<? extends IckleContinuousQueryCacheEventFilterConverter>> getTypeClasses() {
            return Collections.singleton(IckleContinuousQueryCacheEventFilterConverter.class);
        }
    }
}

