/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.hibernate.search.backend.TransactionContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionalEventTransactionContext
implements TransactionContext {
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private static final Log log = LogFactory.getLog(TransactionalEventTransactionContext.class);

    public TransactionalEventTransactionContext(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    @Override
    public boolean isTransactionInProgress() {
        if (this.transactionManager == null) {
            return false;
        }
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            log.debug((Object)"Caught SystemException in TransactionalEventTransactionContext", (Throwable)e);
        }
        return transaction != null;
    }

    @Override
    public Object getTransactionIdentifier() {
        if (this.transactionManager == null) {
            return null;
        }
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            log.debug((Object)"Caught SystemException in TransactionalEventTransactionContext", (Throwable)e);
        }
        return transaction;
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) {
        if (this.transactionSynchronizationRegistry != null) {
            if (synchronization == null) {
                throw new NullPointerException("Synchronization passed in is null!");
            }
            this.transactionSynchronizationRegistry.registerInterposedSynchronization(synchronization);
        } else if (this.transactionManager != null) {
            if (synchronization == null) {
                throw new NullPointerException("Synchronization passed in is null!");
            }
            try {
                Transaction transaction = this.transactionManager.getTransaction();
                transaction.registerSynchronization(synchronization);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

