/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalysisDefinitionSourceService;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.service.classloading.impl.DefaultClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.spi.SearchMappingHelper;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.ErrorHandlerFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.CacheManagerService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.affinity.AffinityErrorHandler;
import org.infinispan.query.affinity.AffinityIndexManager;
import org.infinispan.query.affinity.AffinityShardIdentifierProvider;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.backend.InfinispanLoopbackService;
import org.infinispan.query.backend.LuceneAnalyzerDefinitionsBuilderService;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SearchableCacheConfiguration
extends SearchConfigurationBase
implements SearchConfiguration {
    private static final String HSEARCH_PREFIX = "hibernate.search.";
    private static final String SHARDING_STRATEGY = "sharding_strategy";
    private static final Log log = (Log)LogFactory.getLog(SearchableCacheConfiguration.class, Log.class);
    private final Map<String, Class<?>> classes;
    private final Properties properties;
    private final SearchMapping searchMapping;
    private final Map<Class<? extends Service>, Object> providedServices;
    private final DefaultClassLoaderService classLoaderService = new DefaultClassLoaderService();
    private final LuceneAnalysisDefinitionProvider analyzerDefProvider = null;
    private boolean hasAffinity;

    public SearchableCacheConfiguration(Class<?>[] classArray, Properties properties, EmbeddedCacheManager uninitializedCacheManager, ComponentRegistry cr) {
        this.providedServices = this.initializeProvidedServices(uninitializedCacheManager, cr);
        this.properties = properties == null ? new Properties() : this.augment(properties);
        this.classes = new HashMap();
        for (Class<?> c : classArray) {
            String classname = c.getName();
            this.classes.put(classname, c);
        }
        if (this.hasAffinity) {
            ErrorHandler configuredErrorHandler = ErrorHandlerFactory.createErrorHandler(this);
            this.properties.put("hibernate.search.error_handler", new AffinityErrorHandler(configuredErrorHandler));
        }
        this.searchMapping = SearchMappingHelper.extractSearchMapping(this);
        if (this.searchMapping != null) {
            Set<Class<?>> mappedEntities = this.searchMapping.getMappedEntities();
            for (Class<?> entity : mappedEntities) {
                this.classes.put(entity.getName(), entity);
            }
        }
    }

    private Map initializeProvidedServices(EmbeddedCacheManager uninitializedCacheManager, ComponentRegistry cr) {
        InfinispanLoopbackService loopService = new InfinispanLoopbackService(cr, uninitializedCacheManager);
        HashMap<Class<CacheManagerService>, Service> map = new HashMap<Class<CacheManagerService>, Service>(3);
        map.put(LuceneAnalysisDefinitionSourceService.class, new LuceneAnalyzerDefinitionsBuilderService(this.analyzerDefProvider));
        map.put(ComponentRegistryService.class, loopService);
        map.put(CacheManagerService.class, loopService);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public boolean isDeleteByTermEnforced() {
        return true;
    }

    @Override
    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    @Override
    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ReflectionManager getReflectionManager() {
        return null;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.searchMapping;
    }

    @Override
    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return this.providedServices;
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return false;
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return true;
    }

    private Properties augment(Properties origin) {
        Properties target = new Properties();
        for (Map.Entry<Object, Object> entry : origin.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String && !key.toString().startsWith(HSEARCH_PREFIX)) {
                key = HSEARCH_PREFIX + key.toString();
            }
            target.put(key, entry.getValue());
            if (!key.toString().endsWith("indexmanager") || !entry.getValue().equals(AffinityIndexManager.class.getName())) continue;
            target.put(key.toString().replace("indexmanager", SHARDING_STRATEGY), AffinityShardIdentifierProvider.class.getName());
            this.hasAffinity = true;
        }
        return target;
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }
}

