/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.rpc.RpcManager;

public enum IndexModificationStrategy {
    MANUAL{

        @Override
        public boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx, DistributionManager distributionManager, RpcManager rpcManager, Object key) {
            return false;
        }
    }
    ,
    ALL{

        @Override
        public boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx, DistributionManager distributionManager, RpcManager rpcManager, Object key) {
            return command instanceof ClearCommand || !command.hasAnyFlag(FlagBitSets.SKIP_INDEXING) && (distributionManager == null || distributionManager.getCacheTopology().getDistribution(key).isWriteOwner());
        }
    }
    ,
    LOCAL_ONLY{

        @Override
        public boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx, DistributionManager distributionManager, RpcManager rpcManager, Object key) {
            return PRIMARY_OWNER.shouldModifyIndexes(command, ctx, distributionManager, rpcManager, key);
        }
    }
    ,
    PRIMARY_OWNER{

        @Override
        public boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx, DistributionManager distributionManager, RpcManager rpcManager, Object key) {
            if (key == null) {
                return ctx.isOriginLocal();
            }
            return !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER) && !command.hasAnyFlag(FlagBitSets.SKIP_INDEXING) && (distributionManager == null || distributionManager.getCacheTopology().getDistribution(key).isPrimary());
        }
    };


    public abstract boolean shouldModifyIndexes(FlagAffectedCommand var1, InvocationContext var2, DistributionManager var3, RpcManager var4, Object var5);

    public static IndexModificationStrategy configuredStrategy(SearchIntegrator searchFactory, Configuration cfg) {
        IndexingMode indexingMode = searchFactory.unwrap(SearchIntegrator.class).getIndexingMode();
        if (indexingMode == IndexingMode.MANUAL) {
            return MANUAL;
        }
        if (cfg.indexing().index().isLocalOnly()) {
            return LOCAL_ONLY;
        }
        if (cfg.indexing().index().isPrimaryOwner()) {
            return PRIMARY_OWNER;
        }
        return ALL;
    }
}

