/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.infinispan.query.affinity.AffinityIndexManager;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.indexmanager.AbstractUpdateCommand;
import org.infinispan.query.indexmanager.LuceneWorkConverter;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.LogFactory;

public class AffinityUpdateCommand
extends AbstractUpdateCommand {
    private static final Log log = (Log)LogFactory.getLog(AffinityUpdateCommand.class, Log.class);
    public static final byte COMMAND_ID = 104;

    public AffinityUpdateCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public void setSerializedWorkList(byte[] serializedModel) {
        super.setSerializedWorkList(serializedModel);
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        if (this.queryInterceptor.isStopping()) {
            throw log.cacheIsStoppingNoCommandAllowed(this.cacheName.toString());
        }
        List<LuceneWork> luceneWorks = this.searchFactory.getWorkSerializer().toLuceneWorks(this.serializedModel);
        KeyTransformationHandler handler = this.queryInterceptor.getKeyTransformationHandler();
        List<LuceneWork> workToApply = LuceneWorkConverter.transformKeysToString(luceneWorks, handler);
        for (LuceneWork luceneWork : workToApply) {
            Iterable<IndexManager> indexManagers = this.getIndexManagerForModifications(luceneWork);
            try {
                for (IndexManager im : indexManagers) {
                    if (log.isDebugEnabled()) {
                        log.debugf("Performing remote affinity work %s command on index %s", workToApply, im.getIndexName());
                    }
                    AffinityIndexManager affinityIndexManager = (AffinityIndexManager)im;
                    affinityIndexManager.performOperations(Collections.singletonList(luceneWork), null, false, false);
                }
            }
            catch (Exception e) {
                return CompletableFuture.completedFuture(new ExceptionResponse(e));
            }
        }
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    private Iterable<IndexManager> getIndexManagerForModifications(LuceneWork luceneWork) {
        IndexedTypeIdentifier type = luceneWork.getEntityType();
        Serializable id = luceneWork.getId();
        if (id != null) {
            String idInString = luceneWork.getIdInString();
            Document document = luceneWork.getDocument();
            return Collections.singleton(this.searchFactory.getIndexBinding(type).getIndexManagerSelector().forNew(type, id, idInString, document));
        }
        return this.searchFactory.getIndexBinding(type).getIndexManagerSelector().forExisting(type, null, null);
    }

    @Override
    public byte getCommandId() {
        return 104;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

