/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.util;

import java.lang.reflect.Array;
import java.util.Iterator;

public final class ArrayIterator<T>
implements Iterator<T> {
    private final Object array;
    private int pos = 0;

    public ArrayIterator(Object array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Argument is expected to be an array");
        }
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.pos < Array.getLength(this.array);
    }

    @Override
    public T next() {
        return (T)Array.get(this.array, this.pos++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is immutable");
    }
}

